/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rest.IParameterEvaluator;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public final class RestfulJsonNotificationService
extends AbstractNotificationService {
    public static final String SERVICE_URLS_PREFERENCE = "RestfulJsonNotificationService.serviceUrls";
    private final NotificationResponse EMPTY_RESPONSE = new NotificationResponse();
    private final ResponseExtractor<NotificationResponse> responseExtractor = new ResponseExtractorImpl();
    private IParameterEvaluator usernameEvaluator = null;
    private IParameterEvaluator passwordEvaluator = null;
    private Map<String, IParameterEvaluator> urlParameters;
    private RestTemplate restTemplate;
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;

    @Required
    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    @Required
    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    public void setUrlParameters(Map<String, IParameterEvaluator> urlParameters) {
        this.urlParameters = new HashMap<String, IParameterEvaluator>(urlParameters);
    }

    @Required
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public NotificationResponse fetch(ResourceRequest req) {
        String[] serviceUrls;
        NotificationResponse rslt = this.EMPTY_RESPONSE;
        PortletPreferences prefs = req.getPreferences();
        Map<String, String> params = this.createParameters((PortletRequest)req);
        RequestCallbackImpl requestCallback = new RequestCallbackImpl((PortletRequest)req);
        for (String url : serviceUrls = prefs.getValues(SERVICE_URLS_PREFERENCE, new String[0])) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking uri '" + url + "' with the following parameters:  " + params.toString()));
            }
            try {
                NotificationResponse response = (NotificationResponse)this.restTemplate.execute(url, HttpMethod.GET, (RequestCallback)requestCallback, this.responseExtractor, params);
                rslt = rslt.combine(response);
            }
            catch (Exception e) {
                String msg = "Failed to invoke the following service at '" + url + "' for user " + this.usernameFinder.findUsername((PortletRequest)req);
                this.log.error((Object)msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), "Service Unavailable");
            }
        }
        return rslt;
    }

    private Map<String, String> createParameters(PortletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry<String, IParameterEvaluator> y : this.urlParameters.entrySet()) {
            String key = y.getKey();
            String value = this.urlParameters.get(key).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    private final class ResponseExtractorImpl
    implements ResponseExtractor<NotificationResponse> {
        private final ObjectMapper mapper = new ObjectMapper();

        private ResponseExtractorImpl() {
        }

        public NotificationResponse extractData(ClientHttpResponse res) {
            NotificationResponse rslt = null;
            InputStream inpt = null;
            try {
                inpt = res.getBody();
                rslt = (NotificationResponse)this.mapper.readValue(inpt, NotificationResponse.class);
            }
            catch (Throwable t) {
                RestfulJsonNotificationService.this.log.error((Object)("Failed to invoke the remote service at " + res.getHeaders().getLocation()), t);
                NotificationError error = new NotificationError();
                try {
                    error.setError(res.getRawStatusCode() + ":  " + res.getStatusText());
                }
                catch (IOException e) {
                    RestfulJsonNotificationService.this.log.error((Object)"Failed to read the ClientHttpResponse", (Throwable)e);
                }
                error.setSource(this.getClass().getSimpleName());
                rslt = new NotificationResponse();
                rslt.setErrors(Arrays.asList(error));
            }
            return rslt;
        }
    }

    private final class RequestCallbackImpl
    implements RequestCallback {
        private final PortletRequest portletReq;

        public RequestCallbackImpl(PortletRequest portletReq) {
            this.portletReq = portletReq;
        }

        public void doWithRequest(ClientHttpRequest httpReq) {
            String username = RestfulJsonNotificationService.this.usernameEvaluator.evaluate(this.portletReq);
            String password = RestfulJsonNotificationService.this.passwordEvaluator.evaluate(this.portletReq);
            if (!StringUtils.isBlank((String)username) && !StringUtils.isBlank((String)password)) {
                if (RestfulJsonNotificationService.this.log.isDebugEnabled()) {
                    boolean hasPassword = password != null;
                    RestfulJsonNotificationService.this.log.debug((Object)("Preparing ClientHttpRequest for user '" + username + "' (password provided = " + hasPassword + ")"));
                }
                String authString = username.concat(":").concat(password);
                String encodedAuthString = new Base64().encodeToString(authString.getBytes());
                httpReq.getHeaders().add("Authorization", "Basic ".concat(encodedAuthString));
            }
        }
    }
}

