/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.controller;

import java.io.IOException;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationResult;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class NotificationLifecycleController {
    public static final String DO_EVENTS_PREFERENCE = "NotificationLifecycleController.doEvents";
    public static final String NOTIFICATION_NAMESPACE = "https://source.jasig.org/schemas/portlet/notification";
    public static final String NOTIFICATION_QUERY_LOCAL_NAME = "NotificationQuery";
    public static final QName NOTIFICATION_QUERY_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationQuery");
    public static final String NOTIFICATION_QUERY_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationQuery";
    public static final String NOTIFICATION_RESULT_LOCAL_NAME = "NotificationResult";
    public static final QName NOTIFICATION_RESULT_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationResult");
    public static final String NOTIFICATION_RESULT_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationResult";
    private static final String SUCCESS_PATH = "/scripts/success.json";
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;
    @Resource(name="rootNotificationService")
    private INotificationService notificationService;

    @ActionMapping(params={"action=invokeNotificationService"})
    public void invokeNotificationService(ActionRequest req, ActionResponse res, @RequestParam(value="refresh", required=false) String doRefresh) throws IOException {
        PortletPreferences prefs = req.getPreferences();
        boolean doEvents = Boolean.parseBoolean(prefs.getValue(DO_EVENTS_PREFERENCE, "false"));
        if (doEvents) {
            this.notificationService.invoke(req, res, Boolean.parseBoolean(doRefresh));
        } else {
            String contextPath = req.getContextPath();
            res.sendRedirect(contextPath + SUCCESS_PATH);
        }
    }

    @EventMapping(value="{https://source.jasig.org/schemas/portlet/notification}NotificationResult")
    public void collectNotifications(EventRequest req, EventResponse res) {
        NotificationResult notificationResult;
        PortletPreferences prefs = req.getPreferences();
        boolean doEvents = Boolean.parseBoolean(prefs.getValue(DO_EVENTS_PREFERENCE, "false"));
        if (!doEvents) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing event={https://source.jasig.org/schemas/portlet/notification}NotificationResult for user='" + this.usernameFinder.findUsername((PortletRequest)req) + "' and windowId=" + req.getWindowID()));
        }
        if ((notificationResult = (NotificationResult)req.getEvent().getValue()) != null && req.getWindowID().equals(notificationResult.getQueryWindowId())) {
            this.notificationService.collect(req, res);
        }
    }
}

