/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rest.IParameterEvaluator;
import org.jasig.portlet.notice.service.rest.RestfulJsonNotificationService;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public final class RestfulJsonNotificationService
extends AbstractNotificationService {
    public static final String SERVICE_URLS_PREFERENCE = "RestfulJsonNotificationService.serviceUrls";
    private final NotificationResponse EMPTY_RESPONSE = new NotificationResponse();
    private final ResponseExtractor<NotificationResponse> responseExtractor = new ResponseExtractorImpl(this, null);
    private IParameterEvaluator usernameEvaluator = null;
    private IParameterEvaluator passwordEvaluator = null;
    private Map<String, IParameterEvaluator> urlParameters;
    private RestTemplate restTemplate;
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;

    @Required
    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    @Required
    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    public void setUrlParameters(Map<String, IParameterEvaluator> urlParameters) {
        this.urlParameters = new HashMap<String, IParameterEvaluator>(urlParameters);
    }

    @Required
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public NotificationResponse fetch(ResourceRequest req) {
        String[] serviceUrls;
        NotificationResponse rslt = this.EMPTY_RESPONSE;
        PortletPreferences prefs = req.getPreferences();
        Map params = this.createParameters((PortletRequest)req);
        RequestCallbackImpl requestCallback = new RequestCallbackImpl(this, (PortletRequest)req);
        for (String url : serviceUrls = prefs.getValues(SERVICE_URLS_PREFERENCE, new String[0])) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking uri '" + url + "' with the following parameters:  " + params.toString()));
            }
            try {
                NotificationResponse response = (NotificationResponse)this.restTemplate.execute(url, HttpMethod.GET, (RequestCallback)requestCallback, this.responseExtractor, params);
                rslt = rslt.combine(response);
            }
            catch (Exception e) {
                String msg = "Failed to invoke the following service at '" + url + "' for user " + this.usernameFinder.findUsername((PortletRequest)req);
                this.log.error((Object)msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), "Service Unavailable");
            }
        }
        return rslt;
    }

    private Map<String, String> createParameters(PortletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry y : this.urlParameters.entrySet()) {
            String key = (String)y.getKey();
            String value = ((IParameterEvaluator)this.urlParameters.get(key)).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    static /* synthetic */ IParameterEvaluator access$100(RestfulJsonNotificationService x0) {
        return x0.usernameEvaluator;
    }

    static /* synthetic */ IParameterEvaluator access$200(RestfulJsonNotificationService x0) {
        return x0.passwordEvaluator;
    }

    static /* synthetic */ Log access$300(RestfulJsonNotificationService x0) {
        return x0.log;
    }
}

