/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.classloader;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;

public class ClassLoaderResourceNotificationService
extends AbstractNotificationService {
    public static final String LOCATIONS_PREFERENCE = "ClassLoaderResourceNotificationService.locations";
    private static final NotificationResponse EMPTY_RESPONSE = new NotificationResponse();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;

    @Resource(name="ClassLoaderResourceNotificationService.responseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public NotificationResponse fetch(ResourceRequest req) {
        ArrayList<String> locations = this.getLocations((PortletRequest)req);
        if (locations.isEmpty()) {
            return EMPTY_RESPONSE;
        }
        NotificationResponse rslt = null;
        Element m = this.cache.get(locations);
        if (m != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Locations cache HIT for collection:  " + locations));
            }
            rslt = (NotificationResponse)m.getObjectValue();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Locations cache MISS for collection:  " + locations));
            }
            rslt = new NotificationResponse();
            for (String loc : locations) {
                NotificationResponse response = this.readFromFile(loc);
                rslt = rslt.combine(response);
            }
            this.cache.put(new Element(locations, (Serializable)rslt));
        }
        return rslt;
    }

    @Override
    public final boolean isValid(ResourceRequest req, NotificationResponse previousResponse) {
        return false;
    }

    protected ArrayList<String> getLocations(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] locations = prefs.getValues(LOCATIONS_PREFERENCE, new String[0]);
        ArrayList<String> rslt = new ArrayList<String>(Arrays.asList(locations));
        return rslt;
    }

    private NotificationResponse readFromFile(String filename) {
        NotificationResponse rslt = null;
        URL location = this.getClass().getClassLoader().getResource(filename);
        if (location != null) {
            try {
                File f = new File(location.toURI());
                rslt = (NotificationResponse)this.mapper.readValue(f, NotificationResponse.class);
            }
            catch (Exception e) {
                String msg = "Failed to read the data file:  " + location;
                this.log.error((Object)msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), msg);
            }
        } else {
            String msg = "Data file not found:  " + filename;
            rslt = this.prepareErrorResponse(this.getName(), msg);
        }
        return rslt;
    }
}

