/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service;

import java.util.Arrays;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractNotificationService
implements INotificationService {
    private String name;
    @Autowired
    protected UsernameFinder usernameFinder;

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
    }

    public void collect(EventRequest req, EventResponse res) {
    }

    public boolean isValid(ResourceRequest req, NotificationResponse previousResponse) {
        return true;
    }

    protected final String createServiceUserWindowSpecificCacheKey(PortletRequest req) {
        StringBuilder rslt = new StringBuilder();
        rslt.append(this.getName()).append("|").append(this.usernameFinder.findUsername(req)).append("|").append(req.getWindowID());
        return rslt.toString();
    }

    protected final NotificationResponse prepareErrorResponse(String source, String message) {
        NotificationError error = new NotificationError();
        error.setSource(source);
        error.setError(message);
        NotificationResponse rslt = new NotificationResponse();
        rslt.setErrors(Arrays.asList(error));
        return rslt;
    }
}

