/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.hide;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.action.hide.HideNotificationServiceDecorator;

public final class HideAction
extends NotificationAction {
    public static final HideAction INSTANCE = new HideAction();
    private static final String HIDDEN_NOTIFICATION_IDS_PREFERENCE = HideAction.class.getName() + ".HIDDEN_NOTIFICATION_IDS_PREFERENCE";
    private static final String HIDDEN_NOTIFICATION_TIMESTAMPS_PREFERENCE = HideAction.class.getName() + ".HIDDEN_NOTIFICATION_TIMESTAMPS_PREFERENCE";
    private static final long MILLIS_IN_ONE_HOUR = 3600000L;
    private static final long serialVersionUID = 1L;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public HideAction() {
        this.setLabel("HIDE");
    }

    public void invoke(ActionRequest req) {
        NotificationEntry entry = this.getTarget();
        String notificationId = entry.getId();
        Map<String, Long> hiddenNoticesMap = this.getHiddenNoticesMap((PortletRequest)req);
        if (hiddenNoticesMap.containsKey(notificationId)) {
            hiddenNoticesMap.remove(notificationId);
        } else {
            hiddenNoticesMap.put(notificationId, System.currentTimeMillis());
        }
        this.setHiddenNoticesMap((PortletRequest)req, hiddenNoticesMap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String id = this.getId();
        result = 31 * result + (id == null ? 0 : id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }

    Map<String, Long> getHiddenNoticesMap(PortletRequest req) {
        String[] timestamps;
        HashMap<String, Long> rslt = new HashMap<String, Long>();
        PortletPreferences prefs = req.getPreferences();
        String[] ids = prefs.getValues(HIDDEN_NOTIFICATION_IDS_PREFERENCE, new String[0]);
        if (ids.length != (timestamps = prefs.getValues(HIDDEN_NOTIFICATION_TIMESTAMPS_PREFERENCE, new String[0])).length) {
            this.log.warn((Object)("Collections for ids and timestamps were not the same length for user:  " + req.getRemoteUser()));
        } else {
            try {
                long hideDurationMillis = this.calculateHideDurationMillis(req);
                boolean hideForever = hideDurationMillis == 0L;
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    long timestamp = Long.parseLong(timestamps[i]);
                    if (!hideForever && timestamp + hideDurationMillis <= System.currentTimeMillis()) continue;
                    rslt.put(id, timestamp);
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn((Object)("Failed to build the HideTuple collection for user:  " + req.getRemoteUser()));
                throw new RuntimeException(nfe);
            }
        }
        boolean isActionPhase = req.getAttribute("javax.portlet.lifecycle_phase").equals("ACTION_PHASE");
        if (rslt.size() != ids.length && isActionPhase) {
            this.setHiddenNoticesMap((PortletRequest)((ActionRequest)req), rslt);
        }
        return rslt;
    }

    void setHiddenNoticesMap(PortletRequest req, Map<String, Long> hiddenNoticesMap) {
        String[] ids = new String[hiddenNoticesMap.size()];
        String[] timestamps = new String[hiddenNoticesMap.size()];
        int index = 0;
        for (Map.Entry<String, Long> y : hiddenNoticesMap.entrySet()) {
            ids[index] = y.getKey();
            timestamps[index] = y.getValue().toString();
        }
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValues(HIDDEN_NOTIFICATION_IDS_PREFERENCE, ids);
            prefs.setValues(HIDDEN_NOTIFICATION_TIMESTAMPS_PREFERENCE, timestamps);
            prefs.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    long calculateHideDurationMillis(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String hideDurationHours = prefs.getValue("HideNotificationServiceDecorator.hideDurationHours", HideNotificationServiceDecorator.DEFAULT_HIDE_DURATION.toString());
        long rslt = Long.parseLong(hideDurationHours) * 3600000L;
        return rslt;
    }
}

