/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.controller.emergency;

import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@RequestMapping(value={"VIEW"})
public final class EmergencyAlertController {
    public static final String VIEW_SHOW_ALERTS = "show-alerts";
    private static final String USE_PPORTAL_JS_LIBS_PREFERENCE = "EmergencyAlertController.usePortalJsLibs";
    private static final String PPORTAL_JS_NAMESPACE_PREFERENCE = "EmergencyAlertController.portalJsNamespace";
    private static final String AUTO_ADVANCE_PREFERENCE = "EmergencyAlertController.autoAdvance";
    private final Log log = LogFactory.getLog(this.getClass());
    @Resource(name="rootNotificationService")
    private INotificationService notificationService;
    @Autowired
    private UsernameFinder usernameFinder;

    @RenderMapping
    public ModelAndView showAlert(PortletRequest req) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletPreferences prefs = req.getPreferences();
        boolean usePortalJsLibs = Boolean.valueOf(prefs.getValue(USE_PPORTAL_JS_LIBS_PREFERENCE, "true"));
        model.put("usePortalJsLibs", usePortalJsLibs);
        String portalJsNamespace = prefs.getValue(PPORTAL_JS_NAMESPACE_PREFERENCE, "up");
        model.put("portalJsNamespace", portalJsNamespace);
        boolean autoAdvance = Boolean.valueOf(prefs.getValue(AUTO_ADVANCE_PREFERENCE, null));
        model.put("autoAdvance", autoAdvance);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Showing alerts, usePortalJsLibs=" + usePortalJsLibs + ", portalJsNamespace=" + portalJsNamespace + ", autoAdvance=" + autoAdvance));
        }
        UUID uuid = UUID.randomUUID();
        model.put("uuid", uuid);
        return new ModelAndView(VIEW_SHOW_ALERTS, model);
    }
}

