/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.favorite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.action.favorite.FavoriteAction;

public class FavoriteNotificationServiceDecorator
implements INotificationService {
    public static final String FAVORITE_ENABLED_PREFERENCE = "FavoriteNotificationServiceDecorator.enabled";
    public static final String DEFAULT_FAVORITE_BEHAVIOR = "false";
    private INotificationService enclosedNotificationService;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setEnclosedNotificationService(INotificationService enclosedNotificationService) {
        this.enclosedNotificationService = enclosedNotificationService;
    }

    @Override
    public String getName() {
        return this.enclosedNotificationService.getName();
    }

    @Override
    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.enclosedNotificationService.invoke(req, res, refresh);
    }

    @Override
    public void collect(EventRequest req, EventResponse res) {
        this.enclosedNotificationService.collect(req, res);
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        if (!this.favoritesEnabled(req)) {
            return this.enclosedNotificationService.fetch(req);
        }
        NotificationResponse rslt = null;
        NotificationResponse sourceResponse = this.enclosedNotificationService.fetch(req);
        try {
            rslt = (NotificationResponse)sourceResponse.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.error((Object)"Failed to clone() the sourceResponse", (Throwable)e);
        }
        Set<String> favoriteNotificationIds = FavoriteAction.FAVORITE.getFavoriteNotices(req);
        HashSet<String> potentiallyMissingIds = new HashSet<String>(favoriteNotificationIds);
        for (NotificationCategory category : rslt.getCategories()) {
            for (NotificationEntry entry : category.getEntries()) {
                List currentList = entry.getAvailableActions();
                if (!StringUtils.isNotBlank((String)entry.getId())) continue;
                if (favoriteNotificationIds.contains(entry.getId())) {
                    entry.setFavorite(true);
                    potentiallyMissingIds.remove(entry.getId());
                }
                if (currentList.contains((Object)FavoriteAction.FAVORITE)) continue;
                ArrayList<FavoriteAction> replacementList = new ArrayList<FavoriteAction>(currentList);
                replacementList.add(!entry.isFavorite() ? FavoriteAction.createFavoriteInstance() : FavoriteAction.createUnfavoriteInstance());
                entry.setAvailableActions(replacementList);
            }
        }
        if (rslt.getErrors().isEmpty() && potentiallyMissingIds.size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing " + potentiallyMissingIds.size() + " unreferenced favorites for user " + req.getRemoteUser()));
            }
            FavoriteAction.FAVORITE.removeFavoriteNotices(req, potentiallyMissingIds);
        }
        return rslt;
    }

    private boolean favoritesEnabled(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        return Boolean.valueOf(prefs.getValue(FAVORITE_ENABLED_PREFERENCE, DEFAULT_FAVORITE_BEHAVIOR));
    }

    @Override
    public boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return this.enclosedNotificationService.isValid(req, previousResponse);
    }
}

