/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.classloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.classloader.ClassLoaderResourceNotificationService;

public final class DemoNotificationService
extends ClassLoaderResourceNotificationService {
    public static final String LOCATIONS_PREFERENCE = "DemoNotificationService.locations";
    private static final int MIN_DAY_DELTA = 1;
    private static final int MAX_DAY_DELTA = 14;
    private static final int BLUE_SHIFT = -7;
    private final NotificationResponse EMPTY_RESPONSE = new NotificationResponse();
    private boolean active = true;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse rslt = this.EMPTY_RESPONSE;
        if (this.active) {
            this.log.debug((Object)"Sending a non-empty response because we are ACTIVE");
            rslt = super.fetch(req);
            for (NotificationCategory nc : rslt.getCategories()) {
                for (NotificationEntry y : nc.getEntries()) {
                    if (y.getDueDate() == null) continue;
                    y.setDueDate(this.generateRandomDueDate());
                }
            }
        } else {
            this.log.debug((Object)"Sending an empty response because we are INACTIVE");
        }
        return rslt;
    }

    protected ArrayList<String> getLocations(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] locations = prefs.getValues(LOCATIONS_PREFERENCE, new String[0]);
        ArrayList<String> rslt = new ArrayList<String>(Arrays.asList(locations));
        return rslt;
    }

    private Date generateRandomDueDate() {
        int randomDelta = 1 + (int)(Math.random() * 14.0) + -7;
        GregorianCalendar rslt = new GregorianCalendar();
        rslt.setTimeInMillis(System.currentTimeMillis());
        ((Calendar)rslt).add(5, randomDelta);
        return rslt.getTime();
    }
}

