/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.springframework.beans.factory.annotation.Required;

public final class CacheNotificationService
extends AbstractNotificationService {
    private final Map<String, INotificationService> servicesMap = new HashMap<String, INotificationService>();
    private Cache cache;
    private final Log log = LogFactory.getLog(this.getClass());

    @Required
    public void setEmbeddedServices(List<INotificationService> services) {
        this.servicesMap.clear();
        for (INotificationService s : services) {
            if (this.servicesMap.containsKey(s.getName())) {
                String msg = "Notification services names must be unique;  duplicate detected for name:  " + s.getName();
                throw new IllegalArgumentException(msg);
            }
            this.servicesMap.put(s.getName(), s);
        }
    }

    @Resource(name="notificationResponseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        if (this.log.isTraceEnabled()) {
            String username = this.usernameFinder.findUsername((PortletRequest)req);
            this.log.trace((Object)("Processing invoke() for user ''" + username + "' refresh=" + refresh));
        }
        if (refresh) {
            String cacheKey = this.createServiceUserWindowSpecificCacheKey((PortletRequest)req);
            this.cache.remove((Serializable)((Object)cacheKey));
        }
        for (INotificationService service : this.servicesMap.values()) {
            service.invoke(req, res, refresh);
        }
    }

    @Override
    public void collect(EventRequest req, EventResponse res) {
        for (INotificationService service : this.servicesMap.values()) {
            service.collect(req, res);
        }
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        String username = this.usernameFinder.findUsername(req);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Notifications requested for user='" + username + "' and windowId=" + req.getWindowID()));
        }
        NotificationResponse rslt = new NotificationResponse();
        String cacheKey = this.createServiceUserWindowSpecificCacheKey(req);
        Element m = this.cache.get((Serializable)((Object)cacheKey));
        if (m != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache HIT for user='" + username + "' and windowId=" + req.getWindowID()));
            }
            CacheTuple tuple = (CacheTuple)m.getObjectValue();
            HashMap<String, NotificationResponse> iterable = new HashMap<String, NotificationResponse>(tuple.getResponses());
            for (Map.Entry entry : iterable.entrySet()) {
                INotificationService service = this.servicesMap.get(entry.getKey());
                if (service == null) {
                    this.log.warn((Object)("Unmatched NotificationResponse in CacheTuple;  service.name()='" + (String)entry.getKey() + "' and user='" + username + "'"));
                    tuple.getResponses().remove(entry.getKey());
                }
                if (service.isValid(req, (NotificationResponse)entry.getValue())) continue;
                NotificationResponse freshResponse = this.getResponseFromService(req, service);
                tuple.getResponses().put((String)entry.getKey(), freshResponse);
            }
            for (Map.Entry<String, NotificationResponse> entry : tuple.getResponses().entrySet()) {
                rslt = rslt.combine(entry.getValue());
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache MISS for user='" + username + "' and windowId=" + req.getWindowID()));
            }
            CacheTuple tuple = new CacheTuple();
            for (INotificationService iNotificationService : this.servicesMap.values()) {
                NotificationResponse notificationResponse = this.getResponseFromService(req, iNotificationService);
                tuple.getResponses().put(iNotificationService.getName(), notificationResponse);
            }
            this.cache.put(new Element((Object)cacheKey, (Object)tuple));
            for (Map.Entry entry : tuple.getResponses().entrySet()) {
                rslt = rslt.combine((NotificationResponse)entry.getValue());
            }
        }
        return rslt;
    }

    private final NotificationResponse getResponseFromService(PortletRequest req, INotificationService service) {
        NotificationResponse rslt = null;
        try {
            rslt = service.fetch(req);
        }
        catch (Exception e) {
            String msg = "Failed to invoke the specified service:  " + service.getName();
            this.log.error((Object)msg, (Throwable)e);
            rslt = this.prepareErrorResponse(this.getName(), msg);
        }
        return rslt;
    }

    private static final class CacheTuple {
        private final Map<String, NotificationResponse> responses = new HashMap<String, NotificationResponse>();

        private CacheTuple() {
        }

        public Map<String, NotificationResponse> getResponses() {
            return this.responses;
        }
    }
}

