/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.classloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.classloader.ClassLoaderResourceNotificationService;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DemoNotificationService
extends ClassLoaderResourceNotificationService {
    public static final String LOCATIONS_PREFERENCE = "DemoNotificationService.locations";
    private static final DateTimeFormatter DATE_PARSER = DateTimeFormat.forPattern((String)"MM/dd/YYYY");
    private static final int MIN_DAY_DELTA = 1;
    private static final int MAX_DAY_DELTA = 14;
    private static final int BLUE_SHIFT = -7;
    private final NotificationResponse EMPTY_RESPONSE = new NotificationResponse();
    private boolean active = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse rslt = this.EMPTY_RESPONSE;
        if (this.active) {
            this.log.debug("Sending a non-empty response because we are ACTIVE");
            rslt = super.fetch(req);
            int jobDaysAdjustment = (int)new Duration((ReadableInstant)new LocalDate(2014, 5, 15).toDateTimeAtStartOfDay(), (ReadableInstant)new LocalDate().toDateTimeAtStartOfDay()).getStandardDays();
            for (NotificationCategory nc : rslt.getCategories()) {
                for (NotificationEntry y : nc.getEntries()) {
                    if (y.getDueDate() != null) {
                        y.setDueDate(this.generateRandomDueDate());
                    }
                    this.updateDateAttributeIfPresent(y.getAttributes(), "postDate", jobDaysAdjustment);
                    this.updateDateAttributeIfPresent(y.getAttributes(), "dateClosed", jobDaysAdjustment);
                    this.updateDateAttributeIfPresent(y.getAttributes(), "startDate", jobDaysAdjustment);
                }
            }
        } else {
            this.log.debug("Sending an empty response because we are INACTIVE");
        }
        return rslt;
    }

    @Override
    protected ArrayList<String> getLocations(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] locations = prefs.getValues(LOCATIONS_PREFERENCE, new String[0]);
        return new ArrayList<String>(Arrays.asList(locations));
    }

    private Date generateRandomDueDate() {
        int randomDelta = 1 + (int)(Math.random() * 14.0) + -7;
        GregorianCalendar rslt = new GregorianCalendar();
        rslt.setTimeInMillis(System.currentTimeMillis());
        ((Calendar)rslt).add(5, randomDelta);
        return rslt.getTime();
    }

    private void updateDateAttributeIfPresent(List<NotificationAttribute> attributeList, String attributeName, int addDays) {
        for (NotificationAttribute attr : attributeList) {
            if (!attr.getName().equals(attributeName)) continue;
            if (attr.getValues().size() == 1) {
                LocalDate date = DATE_PARSER.parseLocalDate((String)attr.getValues().get(0));
                attr.setValues(Arrays.asList(DATE_PARSER.print((ReadableInstant)date.plusDays(addDays).toDateTimeAtStartOfDay())));
            } else if (attr.getValues().size() > 1) {
                this.log.warn("Sample data for Notification Attribute {} has {} values; considering only 1st value", (Object)attr.getName(), (Object)attr.getValues().size());
            } else {
                this.log.warn("Sample data for Notification Attribute {} has no values");
            }
            String value = attr.getValues().size() > 0 ? (String)attr.getValues().get(0) : "";
            attr.setValues(Arrays.asList(value));
        }
    }
}

