/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.service.jpa.INotificationDao;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.jasig.portlet.notice.service.jpa.JpaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
class JpaNotificationDao
implements INotificationDao {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    JpaNotificationDao() {
    }

    @Transactional(readOnly=true)
    public JpaEntry getEntry(long entryId) {
        Validate.isTrue((entryId > 0L ? 1 : 0) != 0, (String)("Invalid entryId:  " + entryId));
        JpaEntry rslt = (JpaEntry)this.entityManager.find(JpaEntry.class, (Object)entryId);
        return rslt;
    }

    @Transactional
    public JpaEntry createOrUpdateEntry(JpaEntry entry) {
        Validate.notNull((Object)entry, (String)"Argument 'entry' cannot be null");
        JpaEntry rslt = (JpaEntry)this.entityManager.merge((Object)entry);
        return rslt;
    }

    @Transactional
    public void removeEntry(JpaEntry entry) {
        Validate.notNull((Object)entry, (String)"Argument 'entry' cannot be null");
        JpaEntry y = (JpaEntry)this.entityManager.merge((Object)entry);
        this.entityManager.remove((Object)y);
    }

    @Transactional(readOnly=true)
    public Set<JpaEntry> getEntriesByRecipient(String username) {
        Validate.notEmpty((String)username, (String)"Argument 'username' cannot be empty");
        String jpql = "SELECT DISTINCT v.entry FROM JpaEvent v WHERE v.username = :username";
        TypedQuery query = this.entityManager.createQuery("SELECT DISTINCT v.entry FROM JpaEvent v WHERE v.username = :username", JpaEntry.class);
        this.log.debug("Query getEntriesByRecipient={}", (Object)query.toString());
        query.setParameter("username", (Object)username);
        List rslt = query.getResultList();
        return new HashSet<JpaEntry>(rslt);
    }

    @Transactional(readOnly=true)
    public Set<JpaEntry> getEntriesByRecipientByStatus(String username, Set<NotificationState> include, Set<NotificationState> exclude) {
        Validate.notEmpty((String)username, (String)"Argument 'username' cannot be empty");
        throw new UnsupportedOperationException();
    }

    @Transactional(readOnly=true)
    public List<JpaEvent> getEvents(long entryId, String username) {
        Validate.isTrue((entryId > 0L ? 1 : 0) != 0, (String)"Argument 'entryId' must be greater than zero (0)");
        Validate.notEmpty((String)username, (String)"Argument 'username' cannot be empty");
        String jpql = "SELECT v FROM JpaEvent v WHERE v.username = :username AND v.entry = (SELECT e FROM JpaEntry e WHERE e.id = :entryId) ORDER BY v.timestamp";
        TypedQuery query = this.entityManager.createQuery("SELECT v FROM JpaEvent v WHERE v.username = :username AND v.entry = (SELECT e FROM JpaEntry e WHERE e.id = :entryId) ORDER BY v.timestamp", JpaEvent.class);
        query.setParameter("username", (Object)username);
        query.setParameter("entryId", (Object)entryId);
        List rslt = query.getResultList();
        return rslt;
    }

    @Transactional
    public JpaEvent createOrUpdateEvent(JpaEvent event) {
        Validate.notNull((Object)event, (String)"Argument 'event' cannot be null");
        JpaEvent rslt = (JpaEvent)this.entityManager.merge((Object)event);
        return rslt;
    }
}

