/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.hide;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.action.hide.HideAction;

public class HideNotificationServiceDecorator
implements INotificationService {
    public static final String HIDE_DURATION_HOURS_PREFERENCE = "HideNotificationServiceDecorator.hideDurationHours";
    public static final Integer DEFAULT_HIDE_DURATION = -1;
    private INotificationService enclosedNotificationService;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setEnclosedNotificationService(INotificationService enclosedNotificationService) {
        this.enclosedNotificationService = enclosedNotificationService;
    }

    public String getName() {
        return this.enclosedNotificationService.getName();
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.enclosedNotificationService.invoke(req, res, refresh);
    }

    public void collect(EventRequest req, EventResponse res) {
        this.enclosedNotificationService.collect(req, res);
    }

    public NotificationResponse fetch(PortletRequest req) {
        if (HideAction.INSTANCE.calculateHideDurationMillis(req) < 0L) {
            return this.enclosedNotificationService.fetch(req);
        }
        NotificationResponse sourceResponse = this.enclosedNotificationService.fetch(req);
        NotificationResponse rslt = sourceResponse.cloneIfNotCloned();
        Set currentlyHiddenNotificationIds = HideAction.INSTANCE.getHiddenNoticesMap(req).keySet();
        for (NotificationCategory category : rslt.getCategories()) {
            ArrayList entriesAfterHiding = new ArrayList(category.getEntries());
            for (NotificationEntry entry : category.getEntries()) {
                List currentList = entry.getAvailableActions();
                if (StringUtils.isNotBlank((String)entry.getId()) && !currentList.contains(HideAction.INSTANCE)) {
                    ArrayList<HideAction> replacementList = new ArrayList<HideAction>(currentList);
                    replacementList.add(new HideAction());
                    entry.setAvailableActions(replacementList);
                }
                if (!StringUtils.isNotBlank((String)entry.getId()) || !currentlyHiddenNotificationIds.contains(entry.getId())) continue;
                entriesAfterHiding.remove(entry);
            }
            if (category.getEntries().size() == entriesAfterHiding.size()) continue;
            category.setEntries(entriesAfterHiding);
        }
        return rslt;
    }

    public boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return this.enclosedNotificationService.isValid(req, previousResponse);
    }
}

