/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.jasig.portlet.notice.service.jpa.JpaAction;
import org.jasig.portlet.notice.service.jpa.JpaAddressee;
import org.jasig.portlet.notice.service.jpa.JpaAttribute;

@Entity
@Table(name="NOTICE_ENTRY")
class JpaEntry {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    private long id;
    @Column(name="TITLE", nullable=false)
    private String title;
    @Column(name="SOURCE", nullable=true)
    private String source;
    @Column(name="CATEGORY", nullable=true)
    private String category;
    @Column(name="URL", nullable=true)
    private String url;
    @Column(name="LINK_TEXT", nullable=true)
    private String linkText;
    @Column(name="PRIORITY", nullable=true)
    private int priority;
    @Column(name="DUE_DATE", nullable=true)
    private Timestamp dueDate;
    @Column(name="IMAGE", nullable=true)
    private String image;
    @Lob
    @Column(name="BODY", nullable=true)
    private String body;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTRY_ID")
    private Set<JpaAttribute> attributes = Collections.emptySet();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTRY_ID")
    private Set<JpaAction> actions = Collections.emptySet();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTRY_ID")
    private Set<JpaAddressee> addressees = Collections.emptySet();

    JpaEntry() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Timestamp getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Timestamp dueDate) {
        this.dueDate = dueDate;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Set<JpaAttribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    public void setAttributes(Set<JpaAttribute> attributes) {
        this.attributes.clear();
        this.attributes.addAll(attributes);
    }

    public void addAttribute(JpaAttribute attribute) {
        this.attributes.add(attribute);
    }

    public Set<JpaAction> getActions() {
        return Collections.unmodifiableSet(this.actions);
    }

    public void setActions(Set<JpaAction> actions) {
        this.actions.clear();
        this.actions.addAll(actions);
    }

    public void addAction(JpaAction attribute) {
        this.actions.add(attribute);
    }

    public Set<JpaAddressee> getAddressees() {
        return Collections.unmodifiableSet(this.addressees);
    }

    public void setAddressees(Set<JpaAddressee> addressees) {
        this.addressees.clear();
        this.addressees.addAll(addressees);
    }

    public void addAddressee(JpaAddressee addressee) {
        this.addressees.add(addressee);
    }
}

