/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.jasig.portlet.notice.rest.RecipientType;
import org.jasig.portlet.notice.service.jpa.JpaRecipient;

@Entity
@Table(name="NOTICE_ADDRESSEE")
class JpaAddressee {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    private long id;
    @Column(name="ENTRY_ID", nullable=false)
    private long entryId;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="TYPE", nullable=false)
    private RecipientType type;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ADDRESSEE_ID")
    private Set<JpaRecipient> recipients = new HashSet<JpaRecipient>();

    JpaAddressee() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    public RecipientType getType() {
        return this.type;
    }

    public void setType(RecipientType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<JpaRecipient> getRecipients() {
        return Collections.unmodifiableSet(this.recipients);
    }

    public void setRecipients(Set<JpaRecipient> recipients) {
        this.recipients.clear();
        for (JpaRecipient recip : recipients) {
            this.addRecipient(recip);
        }
    }

    public void addRecipient(JpaRecipient recipient) {
        this.recipients.add(recipient);
        recipient.setAddresseeId(this.getId());
    }
}

