/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import org.jasig.portlet.notice.rest.EntryDTO;
import org.jasig.portlet.notice.service.jpa.AddresseePostProcessor;
import org.jasig.portlet.notice.service.jpa.IMappedClassPostProcessor;
import org.jasig.portlet.notice.service.jpa.JpaAction;
import org.jasig.portlet.notice.service.jpa.JpaAddressee;
import org.jasig.portlet.notice.service.jpa.JpaAttribute;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaEntryPostProcessor
implements IMappedClassPostProcessor<JpaEntry, EntryDTO> {
    private AddresseePostProcessor addresseePostProcessor = new AddresseePostProcessor();

    @Autowired
    public void setAddresseePostProcessor(AddresseePostProcessor addresseePostProcessor) {
        this.addresseePostProcessor = addresseePostProcessor;
    }

    public void process(JpaEntry mappedObject, EntryDTO src) {
        for (JpaAttribute attr : mappedObject.getAttributes()) {
            attr.setEntryId(mappedObject.getId());
        }
        for (JpaAddressee addr : mappedObject.getAddressees()) {
            addr.setEntryId(mappedObject.getId());
            this.addresseePostProcessor.process(addr, null);
        }
        for (JpaAction action : mappedObject.getActions()) {
            action.setEntryId(mappedObject.getId());
        }
    }
}

