/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.service.jpa.INotificationDao;
import org.jasig.portlet.notice.service.jpa.JpaAddressee;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.jasig.portlet.notice.service.jpa.JpaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
class JpaNotificationDao
implements INotificationDao {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    JpaNotificationDao() {
    }

    @Override
    @Transactional(readOnly=true)
    public JpaEntry getEntry(long entryId) {
        Validate.isTrue((entryId > 0L ? 1 : 0) != 0, (String)("Invalid entryId:  " + entryId));
        JpaEntry rslt = (JpaEntry)this.entityManager.find(JpaEntry.class, (Object)entryId);
        return rslt;
    }

    @Override
    @Transactional(readOnly=true)
    public JpaEntry getFullEntry(long entryId) {
        Validate.isTrue((entryId > 0L ? 1 : 0) != 0, (String)("Invalid entryId: " + entryId));
        TypedQuery query = this.entityManager.createNamedQuery("JpaEntry.getFullById", JpaEntry.class);
        query.setParameter("entryId", (Object)entryId);
        return (JpaEntry)query.getSingleResult();
    }

    @Override
    @Transactional(readOnly=true)
    public List<JpaEntry> list(Integer page, Integer pageSize) {
        TypedQuery query = this.entityManager.createNamedQuery("JpaEntry.getAll", JpaEntry.class);
        if (page != null && pageSize != null) {
            query.setFirstResult(page * pageSize);
            query.setMaxResults(pageSize.intValue());
        }
        return query.getResultList();
    }

    @Override
    @Transactional
    public JpaEntry createOrUpdateEntry(JpaEntry entry) {
        Validate.notNull((Object)entry, (String)"Argument 'entry' cannot be null");
        if (entry.getId() == 0L) {
            this.entityManager.persist((Object)entry);
            this.entityManager.flush();
        } else {
            entry = (JpaEntry)this.entityManager.merge((Object)entry);
        }
        return entry;
    }

    @Override
    @Transactional
    public void removeEntry(JpaEntry entry) {
        Validate.notNull((Object)entry, (String)"Argument 'entry' cannot be null");
        JpaEntry y = (JpaEntry)this.entityManager.merge((Object)entry);
        this.entityManager.remove((Object)y);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<JpaEntry> getEntriesByRecipient(String username) {
        Validate.notEmpty((String)username, (String)"Argument 'username' cannot be empty");
        String jpql = "SELECT DISTINCT v.entry FROM JpaEvent v WHERE v.username = :username";
        TypedQuery query = this.entityManager.createQuery("SELECT DISTINCT v.entry FROM JpaEvent v WHERE v.username = :username", JpaEntry.class);
        this.log.debug("Query getEntriesByRecipient={}", (Object)query.toString());
        query.setParameter("username", (Object)username);
        List rslt = query.getResultList();
        return new HashSet<JpaEntry>(rslt);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<JpaEntry> getEntriesByRecipientByStatus(String username, Set<NotificationState> include, Set<NotificationState> exclude) {
        Validate.notEmpty((String)username, (String)"Argument 'username' cannot be empty");
        throw new UnsupportedOperationException();
    }

    @Override
    @Transactional(readOnly=true)
    public List<JpaEvent> getEvents(long entryId) {
        Validate.isTrue((entryId > 0L ? 1 : 0) != 0, (String)"Argument 'entryId' must be greater than zero (0)");
        TypedQuery query = this.entityManager.createNamedQuery("JpaEvent.getAllByEntryId", JpaEvent.class);
        query.setParameter("entryId", (Object)entryId);
        List events = query.getResultList();
        return events;
    }

    @Override
    @Transactional(readOnly=true)
    public List<JpaEvent> getEvents(long entryId, String username) {
        Validate.isTrue((entryId > 0L ? 1 : 0) != 0, (String)"Argument 'entryId' must be greater than zero (0)");
        Validate.notEmpty((String)username, (String)"Argument 'username' cannot be empty");
        String jpql = "SELECT v FROM JpaEvent v WHERE v.username = :username AND v.entry = (SELECT e FROM JpaEntry e WHERE e.id = :entryId) ORDER BY v.timestamp";
        TypedQuery query = this.entityManager.createQuery("SELECT v FROM JpaEvent v WHERE v.username = :username AND v.entry = (SELECT e FROM JpaEntry e WHERE e.id = :entryId) ORDER BY v.timestamp", JpaEvent.class);
        query.setParameter("username", (Object)username);
        query.setParameter("entryId", (Object)entryId);
        List rslt = query.getResultList();
        return rslt;
    }

    @Override
    @Transactional
    public JpaAddressee createOrUpdateAddressee(JpaAddressee addressee) {
        Validate.notNull((Object)addressee, (String)"Argument 'addressee' cannot be null");
        if (addressee.getId() == 0L) {
            this.entityManager.persist((Object)addressee);
            this.entityManager.flush();
        } else {
            addressee = (JpaAddressee)this.entityManager.merge((Object)addressee);
        }
        return addressee;
    }

    @Override
    @Transactional(readOnly=true)
    public JpaAddressee getAddressee(long addresseeId) {
        Validate.isTrue((addresseeId > 0L ? 1 : 0) != 0, (String)"'addresseeId' must be greater than 0");
        JpaAddressee addr = (JpaAddressee)this.entityManager.find(JpaAddressee.class, (Object)addresseeId);
        return addr;
    }

    @Override
    @Transactional
    public JpaEvent createOrUpdateEvent(JpaEvent event) {
        Validate.notNull((Object)event, (String)"Argument 'event' cannot be null");
        if (event.getId() == 0L) {
            this.entityManager.persist((Object)event);
            this.entityManager.flush();
        } else {
            event = (JpaEvent)this.entityManager.merge((Object)event);
        }
        return event;
    }

    @Override
    @Transactional(readOnly=true)
    public JpaEvent getEvent(long eventId) {
        JpaEvent event = (JpaEvent)this.entityManager.find(JpaEvent.class, (Object)eventId);
        return event;
    }
}

