/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.favorite;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationEntry;

public final class FavoriteAction
extends NotificationAction {
    public static final FavoriteAction FAVORITE = new FavoriteAction();
    private static final String FAVORITE_NOTIFICATION_IDS_PREFERENCE = FavoriteAction.class.getName() + ".FAVORITE_NOTIFICATION_IDS_PREFERENCE";
    private static final long serialVersionUID = 1L;

    public FavoriteAction() {
        this.setLabel("FAVORITE");
    }

    public FavoriteAction(String label) {
        this.setLabel(label);
    }

    public static final FavoriteAction createFavoriteInstance() {
        return new FavoriteAction();
    }

    public static final FavoriteAction createUnfavoriteInstance() {
        return new FavoriteAction("UNFAVORITE");
    }

    public void invoke(ActionRequest req, ActionResponse res) throws IOException {
        NotificationEntry entry = this.getTarget();
        String notificationId = entry.getId();
        Set favoriteNotices = this.getFavoriteNotices((PortletRequest)req);
        if (favoriteNotices.contains(notificationId)) {
            favoriteNotices.remove(notificationId);
        } else {
            favoriteNotices.add(notificationId);
        }
        this.setFavoriteNotices((PortletRequest)req, favoriteNotices);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String id = this.getId();
        result = 31 * result + (id == null ? 0 : id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public void removeFavoriteNotices(PortletRequest req, Set<String> idsToRemove) {
        Set currentIds = this.getFavoriteNotices(req);
        currentIds.removeAll(idsToRemove);
        this.setFavoriteNotices(req, currentIds);
    }

    Set<String> getFavoriteNotices(PortletRequest req) {
        HashSet<String> rslt = new HashSet<String>();
        PortletPreferences prefs = req.getPreferences();
        String[] ids = prefs.getValues(FAVORITE_NOTIFICATION_IDS_PREFERENCE, new String[0]);
        for (int i = 0; i < ids.length; ++i) {
            rslt.add(ids[i]);
        }
        return rslt;
    }

    void setFavoriteNotices(PortletRequest req, Set<String> favoriteNotices) {
        String[] ids = favoriteNotices.toArray(new String[favoriteNotices.size()]);
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValues(FAVORITE_NOTIFICATION_IDS_PREFERENCE, ids);
            prefs.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

