/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.hide;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.action.hide.HideNotificationServiceDecorator;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.util.JpaServices;
import org.jasig.portlet.notice.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HideAction
extends NotificationAction {
    public static final String HIDE_DURATION_HOURS_ATTRIBUTE_NAME = HideAction.class.getName() + ".HIDE_DURATION_HOURS_ATTRIBUTE_NAME";
    public static final HideAction INSTANCE = new HideAction();
    private static final long MILLIS_IN_ONE_HOUR = 3600000L;
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(HideAction.class);

    public HideAction() {
        this.setLabel("HIDE");
    }

    public void invoke(ActionRequest req, ActionResponse res) throws IOException {
        NotificationEntry entry = this.getTarget();
        if (!this.isEntrySnoozed(entry, (PortletRequest)req)) {
            this.hide(entry, req);
        } else {
            this.unhide(entry, req);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String id = this.getId();
        result = 31 * result + (id == null ? 0 : id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }

    long calculateHideDurationMillis(NotificationEntry entry, PortletRequest req) {
        List values;
        PortletPreferences prefs = req.getPreferences();
        String hideDurationHours = prefs.getValue("HideNotificationServiceDecorator.hideDurationHours", HideNotificationServiceDecorator.DEFAULT_HIDE_DURATION.toString());
        Map attributes = entry.getAttributesMap();
        if (attributes.containsKey(HIDE_DURATION_HOURS_ATTRIBUTE_NAME) && (values = (List)attributes.get(HIDE_DURATION_HOURS_ATTRIBUTE_NAME)).size() != 0) {
            hideDurationHours = (String)values.get(0);
        }
        this.logger.debug("Calculated hideDurationHours={} for entry with id='{}', title='{}'", new Object[]{hideDurationHours, entry.getId(), entry.getTitle()});
        long rslt = Long.parseLong(hideDurationHours) * 3600000L;
        return rslt;
    }

    boolean isEntrySnoozed(NotificationEntry entry, PortletRequest req) {
        if (StringUtils.isBlank((String)entry.getId())) {
            return false;
        }
        boolean rslt = false;
        long snoozeDurationMillis = this.calculateHideDurationMillis(entry, req);
        JpaServices jpaServices = (JpaServices)SpringContext.getApplicationContext().getBean("jpaServices");
        List<EventDTO> history = jpaServices.getHistory(entry, req.getRemoteUser());
        this.logger.debug("List<EventDTO> within getNotificationsBySourceAndCustomAttribute contains {} elements", (Object)history.size());
        for (EventDTO event : history) {
            switch (event.getState()) {
                case SNOOZED: {
                    this.logger.debug("Found a SNOOZED event:  {}", (Object)event);
                    if (event.getTimestamp().getTime() + snoozeDurationMillis <= System.currentTimeMillis()) break;
                    rslt = true;
                    break;
                }
                case ISSUED: {
                    this.logger.debug("Found an ISSUED event:  {}", (Object)event);
                    rslt = false;
                    break;
                }
            }
        }
        this.logger.debug("Returning SNOOZED='{}' for the following notification:  {}", (Object)rslt, (Object)entry);
        return rslt;
    }

    private void hide(NotificationEntry entry, ActionRequest req) {
        JpaServices jpaServices = (JpaServices)SpringContext.getApplicationContext().getBean("jpaServices");
        jpaServices.applyState(entry, req.getRemoteUser(), NotificationState.SNOOZED);
    }

    private void unhide(NotificationEntry entry, ActionRequest req) {
        JpaServices jpaServices = (JpaServices)SpringContext.getApplicationContext().getBean("jpaServices");
        jpaServices.applyState(entry, req.getRemoteUser(), NotificationState.ISSUED);
    }
}

