/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.controller.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portlet.notice.rest.AddresseeDTO;
import org.jasig.portlet.notice.rest.EntryDTO;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.service.jpa.IJpaNotificationRESTService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/v1/notifications"})
public class JPANotificationRESTController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    static final String REQUEST_ROOT = "/v1/notifications";
    private static final String API_ROOT = "/api";
    @Autowired
    private IJpaNotificationRESTService restService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<EntryDTO> getNotifications(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.restService.getNotifications(page, pageSize);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public EntryDTO createNotification(HttpServletRequest req, HttpServletResponse response, @RequestBody EntryDTO entry) {
        EntryDTO persisted = this.restService.createNotification(entry);
        String url = this.getSingleNotificationRESTUrl(req, persisted.getId());
        response.addHeader("Location", url);
        return persisted;
    }

    @RequestMapping(value={"/{notificationId}"}, method={RequestMethod.GET})
    @ResponseBody
    public EntryDTO getNotification(HttpServletResponse response, @PathVariable(value="notificationId") long id, @RequestParam(value="full", required=false, defaultValue="false") boolean full) {
        EntryDTO notification = this.restService.getNotification(id, full);
        if (notification == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        return notification;
    }

    @RequestMapping(value={"/{notificationId}/addressees"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<AddresseeDTO> getAddressees(@PathVariable(value="notificationId") long id) {
        return this.restService.getAddressees(id);
    }

    @RequestMapping(value={"/{notificationId}/addressees"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public AddresseeDTO addAddressee(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="notificationId") long id, @RequestBody AddresseeDTO addressee) {
        AddresseeDTO dto = this.restService.createAddressee(id, addressee);
        if (dto == null) {
            resp.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        String url = this.getSingleNotificationRESTUrl(req, id) + "/addressee/" + dto.getId();
        resp.addHeader("Location", url);
        return dto;
    }

    @RequestMapping(value={"/{notificationId}/addressees/{addresseeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AddresseeDTO getAddressee(HttpServletResponse resp, @PathVariable(value="notificationId") long notificationId, @PathVariable(value="addresseeId") long addresseeId) {
        AddresseeDTO dto = this.restService.getAddressee(addresseeId);
        if (dto == null) {
            resp.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        return dto;
    }

    @RequestMapping(value={"/{notificationId}/events"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EventDTO> getEventsByNotification(@PathVariable(value="notificationId") long id) {
        return this.restService.getEventsByNotification(id);
    }

    @RequestMapping(value={"/{notificationId}/events/{eventId}"}, method={RequestMethod.GET})
    @ResponseBody
    public EventDTO getEvent(HttpServletResponse response, @PathVariable(value="notificationId") long notificationId, @PathVariable(value="eventId") long eventId) {
        EventDTO event = this.restService.getEvent(eventId);
        if (event == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        return event;
    }

    @RequestMapping(value={"/{notificationId}/events"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public EventDTO createEvent(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="notificationId") long notificationId, @RequestBody EventDTO event) {
        EventDTO dto = this.restService.createEvent(notificationId, event);
        if (dto == null) {
            resp.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        String url = this.getSingleNotificationRESTUrl(req, notificationId) + "/state/" + dto.getId();
        resp.addHeader("Location", url);
        return dto;
    }

    private String getSingleNotificationRESTUrl(HttpServletRequest request, long id) {
        String path = request.getContextPath() + API_ROOT + REQUEST_ROOT + id;
        try {
            URL url = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), path);
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            this.log.warn("Error building Location header", (Throwable)e);
            return path;
        }
    }
}

