/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.rest.AttributeDTO;
import org.jasig.portlet.notice.rest.EntryDTO;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.service.jpa.IJpaNotificationRESTService;
import org.jasig.portlet.notice.service.jpa.JpaNotificationService;
import org.jasig.portlet.notice.util.IJpaServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jpaServices")
public class JpaServices
implements IJpaServices {
    private static final String PROXY_SOURCE_NAME = JpaServices.class.getName() + ".PROXY_SOURCE_NAME";
    private static final String PROXY_ID_ATTRIBUTE = JpaServices.class.getName() + ".PROXY_ID_ATTRIBUTE";
    private static final String PROXY_BODY_CONTENT = "This is a proxy notification representing one from an external data source;  this strategy supports status changes.";
    @Autowired
    JpaNotificationService jpaNotificationService;
    @Autowired
    IJpaNotificationRESTService jpaNotificationRestService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<EventDTO> getHistory(NotificationEntry entry, String username) {
        EntryDTO entryDto;
        List<EventDTO> rslt = Collections.emptyList();
        EntryDTO entryDTO = entryDto = this.jpaNotificationService.contains(entry) ? this.jpaNotificationRestService.getNotification(entry, false) : this.fetchJpaProxyIfAvailable(entry);
        if (entryDto != null) {
            rslt = this.jpaNotificationRestService.getEventsByNotificationAndUser(entryDto.getId(), username);
        }
        return rslt;
    }

    @Override
    public void applyState(NotificationEntry entry, String username, NotificationState state) {
        EntryDTO entryDto = this.jpaNotificationService.contains(entry) ? this.jpaNotificationRestService.getNotification(entry, false) : this.fetchOrCreateJpaProxy(entry);
        EventDTO event = new EventDTO();
        event.setState(state);
        event.setTimestamp(new Timestamp(System.currentTimeMillis()));
        event.setUsername(username);
        this.jpaNotificationRestService.createEvent(entryDto.getId(), event);
    }

    private EntryDTO fetchJpaProxyIfAvailable(NotificationEntry entry) {
        EntryDTO rslt = null;
        List<EntryDTO> list = this.jpaNotificationRestService.getNotificationsBySourceAndCustomAttribute(PROXY_SOURCE_NAME, PROXY_ID_ATTRIBUTE, entry.getId());
        this.logger.debug("Search for JPA-backed entry with id='{}' returned the following:  {}", (Object)entry.getId(), list);
        switch (list.size()) {
            case 1: {
                rslt = list.get(0);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("More than one JPA-back entry exists for id=" + entry.getId());
            }
        }
        return rslt;
    }

    private EntryDTO fetchOrCreateJpaProxy(NotificationEntry entry) {
        EntryDTO rslt = this.fetchJpaProxyIfAvailable(entry);
        if (rslt == null) {
            EntryDTO newEntry = new EntryDTO();
            ArrayList<String> values = new ArrayList<String>();
            values.add(entry.getId());
            AttributeDTO idAttribute = new AttributeDTO();
            idAttribute.setName(PROXY_ID_ATTRIBUTE);
            idAttribute.setValues(values);
            HashSet<AttributeDTO> attributes = new HashSet<AttributeDTO>();
            attributes.add(idAttribute);
            newEntry.setAttributes(attributes);
            newEntry.setSource(PROXY_SOURCE_NAME);
            newEntry.setTitle(entry.getTitle());
            newEntry.setBody(PROXY_BODY_CONTENT);
            rslt = this.jpaNotificationRestService.createNotification(newEntry);
        }
        return rslt;
    }
}

