/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.filter;

import java.util.ArrayList;
import java.util.HashSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.filter.FilteringNotificationServiceDecorator;
import org.jasig.portlet.notice.service.filter.INotificationFilter;
import org.jasig.portlet.notice.util.PortletXmlRoleService;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilteringNotificationServiceDecorator
implements INotificationService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String PORTLET_XML_ROLE_SERVICE_ATTRIBUTE = "FilteringNotificationServiceDecorator.portletXmlRoleService";
    private INotificationService enclosedNotificationService;
    @Autowired
    private UsernameFinder usernameFinder;
    @Autowired
    private PortletXmlRoleService portletXmlRoleService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setEnclosedNotificationService(INotificationService enclosedNotificationService) {
        this.enclosedNotificationService = enclosedNotificationService;
    }

    public String getName() {
        return this.enclosedNotificationService.getName();
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.enclosedNotificationService.invoke(req, res, refresh);
    }

    public void collect(EventRequest req, EventResponse res) {
        this.enclosedNotificationService.collect(req, res);
    }

    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse unfilteredResponse = this.enclosedNotificationService.fetch(req);
        HashSet filters = new HashSet();
        req.setAttribute("FilteringNotificationServiceDecorator.portletXmlRoleService", (Object)this.portletXmlRoleService);
        for (FilterMapper mapper : FilterMapper.values()) {
            filters.addAll(mapper.fromPortletRequest(req));
        }
        if (filters.size() == 0) {
            this.logger.debug("No INotificationFilter objects apply to notifications for username='{}' and windowID='{}'", (Object)this.usernameFinder.findUsername(req), (Object)req.getWindowID());
            return unfilteredResponse;
        }
        this.logger.debug("Found the following INotificationFilter objects for username='{}' and windowID='{}':  {}", new Object[]{this.usernameFinder.findUsername(req), req.getWindowID(), filters});
        ArrayList<NotificationCategory> filteredCategories = new ArrayList<NotificationCategory>();
        for (NotificationCategory unfilteredCategory : unfilteredResponse.getCategories()) {
            ArrayList<NotificationEntry> filteredEntries = new ArrayList<NotificationEntry>();
            for (NotificationEntry entry : unfilteredCategory.getEntries()) {
                boolean excluded = false;
                for (INotificationFilter filter : filters) {
                    if (filter.doFilter(unfilteredCategory, entry)) continue;
                    excluded = true;
                    break;
                }
                if (excluded) continue;
                filteredEntries.add(entry);
            }
            if (filteredEntries.size() == 0) continue;
            NotificationCategory category = new NotificationCategory();
            category.setTitle(unfilteredCategory.getTitle());
            category.setEntries(filteredEntries);
            filteredCategories.add(category);
        }
        NotificationResponse rslt = new NotificationResponse();
        rslt.setCategories(filteredCategories);
        rslt.setErrors(unfilteredResponse.getErrors());
        return rslt;
    }

    public boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return this.enclosedNotificationService.isValid(req, previousResponse);
    }

    static /* synthetic */ String[] access$100() {
        return EMPTY_STRING_ARRAY;
    }
}

