/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rest.IParameterEvaluator;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public final class RestfulJsonNotificationService
extends AbstractNotificationService {
    public static final String SERVICE_URLS_PREFERENCE = "RestfulJsonNotificationService.serviceUrls";
    private final NotificationResponse EMPTY_RESPONSE = new NotificationResponse();
    private final ResponseExtractor<NotificationResponse> responseExtractor = new ResponseExtractorImpl();
    private IParameterEvaluator usernameEvaluator = null;
    private IParameterEvaluator passwordEvaluator = null;
    private Map<String, IParameterEvaluator> urlParameters;
    private RestTemplate restTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;

    @Required
    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    @Required
    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    @Autowired
    public void setUrlParameterEvaluators(Set<IParameterEvaluator> evaluators) {
        HashMap map = new HashMap();
        evaluators.stream().forEach(evaluator -> map.put(evaluator.getToken(), evaluator));
        this.urlParameters = Collections.unmodifiableMap(map);
        this.logger.info("Found the following IParameterEvaluator beans:  {}", this.urlParameters);
    }

    @Required
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        String[] serviceUrls;
        NotificationResponse rslt = this.EMPTY_RESPONSE;
        PortletPreferences prefs = req.getPreferences();
        Map<String, String> params = this.createParameters(req);
        RequestCallbackImpl requestCallback = new RequestCallbackImpl(req);
        for (String url : serviceUrls = prefs.getValues(SERVICE_URLS_PREFERENCE, new String[0])) {
            this.logger.debug("Invoking uri '{}' with the following parameters:  {}", (Object)url, params);
            try {
                NotificationResponse response = (NotificationResponse)this.restTemplate.execute(url, HttpMethod.GET, (RequestCallback)requestCallback, this.responseExtractor, params);
                rslt = rslt.combine(response);
            }
            catch (Exception e) {
                String msg = "Failed to invoke the following service at '" + url + "' for user " + this.usernameFinder.findUsername(req);
                this.logger.error(msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), "Service Unavailable");
            }
        }
        return rslt;
    }

    private Map<String, String> createParameters(PortletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry<String, IParameterEvaluator> y : this.urlParameters.entrySet()) {
            String key = y.getKey();
            String value = this.urlParameters.get(key).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    private final class ResponseExtractorImpl
    implements ResponseExtractor<NotificationResponse> {
        private final ObjectMapper mapper = new ObjectMapper();

        private ResponseExtractorImpl() {
        }

        public NotificationResponse extractData(ClientHttpResponse res) {
            NotificationResponse rslt;
            try (InputStream inpt = res.getBody();){
                rslt = (NotificationResponse)this.mapper.readValue(inpt, NotificationResponse.class);
                RestfulJsonNotificationService.this.logger.debug("Produced the following NotificationResponse based on the ClientHttpResponse:  {}", (Object)rslt);
            }
            catch (Throwable t) {
                RestfulJsonNotificationService.this.logger.error("Failed to invoke the remote service at " + res.getHeaders().getLocation(), t);
                NotificationError error = new NotificationError();
                try {
                    error.setError(res.getRawStatusCode() + ":  " + res.getStatusText());
                }
                catch (IOException e) {
                    RestfulJsonNotificationService.this.logger.error("Failed to read the ClientHttpResponse", (Throwable)e);
                }
                error.setSource(this.getClass().getSimpleName());
                rslt = new NotificationResponse();
                rslt.setErrors(Collections.singletonList(error));
            }
            return rslt;
        }
    }

    private final class RequestCallbackImpl
    implements RequestCallback {
        private final PortletRequest portletReq;

        public RequestCallbackImpl(PortletRequest portletReq) {
            this.portletReq = portletReq;
        }

        public void doWithRequest(ClientHttpRequest httpReq) {
            String username = RestfulJsonNotificationService.this.usernameEvaluator.evaluate(this.portletReq);
            String password = RestfulJsonNotificationService.this.passwordEvaluator.evaluate(this.portletReq);
            if (!StringUtils.isBlank((String)username) && !StringUtils.isBlank((String)password)) {
                RestfulJsonNotificationService.this.logger.debug("Preparing ClientHttpRequest for user '{}' (password provided = true)", (Object)username);
                String authString = username.concat(":").concat(password);
                String encodedAuthString = new Base64().encodeToString(authString.getBytes());
                httpReq.getHeaders().add("Authorization", "Basic ".concat(encodedAuthString));
            }
        }
    }
}

