/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class PortletXmlRoleService
implements ServletContextAware {
    private static final String PORTLET_XML_PATH = "/WEB-INF/portlet.xml";
    private Set<String> roles = Collections.emptySet();
    private ServletContext context;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    @PostConstruct
    public void init() {
        Document doc = this.parseXml();
        if (doc != null) {
            HashSet<String> set = new HashSet<String>();
            NodeList roleSections = doc.getElementsByTagName("security-role-ref");
            for (int i = 0; i < roleSections.getLength(); ++i) {
                if (!roleSections.item(i).hasChildNodes()) continue;
                NodeList roleNames = roleSections.item(i).getChildNodes();
                for (int j = 0; j < roleNames.getLength(); ++j) {
                    if (!roleNames.item(j).getNodeName().equalsIgnoreCase("role-name")) continue;
                    String roleNameCandidate = roleNames.item(j).getTextContent();
                    set.add(roleNameCandidate);
                }
            }
            this.roles = Collections.unmodifiableSet(set);
            this.logger.info("Successfully instantiated and found roles: {}", this.roles);
        } else {
            this.logger.error("Error parsing the file: {}. See other messages for trace.", (Object)PORTLET_XML_PATH);
        }
    }

    public Set<String> getAllRoles() {
        return this.roles;
    }

    private Document parseXml() {
        Document rslt = null;
        try {
            URL portletXmlUrl = this.context.getResource(PORTLET_XML_PATH);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            InputSource xmlInp = new InputSource(portletXmlUrl.openStream());
            DocumentBuilder dbl = dbf.newDocumentBuilder();
            rslt = dbl.parse(xmlInp);
            this.logger.debug("Finished parsing ", (Object)PORTLET_XML_PATH);
        }
        catch (Exception e) {
            this.logger.error("Failed to parse the specified document: {}", (Object)PORTLET_XML_PATH, (Object)e);
        }
        return rslt;
    }
}

