/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.hide;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.action.hide.HideAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HideNotificationServiceDecorator
implements INotificationService {
    public static final String HIDE_DURATION_HOURS_PREFERENCE = "HideNotificationServiceDecorator.hideDurationHours";
    public static final long HIDE_DURATION_NONE = -1L;
    private INotificationService enclosedNotificationService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setEnclosedNotificationService(INotificationService enclosedNotificationService) {
        this.enclosedNotificationService = enclosedNotificationService;
    }

    public String getName() {
        return this.enclosedNotificationService.getName();
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.enclosedNotificationService.invoke(req, res, refresh);
    }

    public void collect(EventRequest req, EventResponse res) {
        this.enclosedNotificationService.collect(req, res);
    }

    public NotificationResponse fetch(PortletRequest req) {
        this.logger.debug("Processing notifications for username='{}'", (Object)req.getRemoteUser());
        NotificationResponse sourceResponse = this.enclosedNotificationService.fetch(req);
        NotificationResponse rslt = sourceResponse.cloneIfNotCloned();
        for (NotificationCategory category : rslt.getCategories()) {
            ArrayList entriesAfterHiding = new ArrayList(category.getEntries());
            for (NotificationEntry entry : category.getEntries()) {
                List currentList = entry.getAvailableActions();
                if (StringUtils.isNotBlank((String)entry.getId()) && !currentList.stream().anyMatch(action -> action instanceof HideAction) && HideAction.INSTANCE.calculateHideDurationMillis(entry, req) > -1L) {
                    this.logger.debug("Adding hide action to notification with id='{}' for username='{}'", (Object)entry.getId(), (Object)req.getRemoteUser());
                    ArrayList<HideAction> replacementList = new ArrayList<HideAction>(currentList);
                    replacementList.add(new HideAction());
                    entry.setAvailableActions(replacementList);
                }
                if (!entry.getAvailableActions().stream().filter(action -> action instanceof HideAction).anyMatch(action -> ((HideAction)action).isEntrySnoozed(entry, req))) continue;
                this.logger.debug("Hiding entry with id='{}' for username='{}' based on user's previous action", (Object)entry.getId(), (Object)req.getRemoteUser());
                entriesAfterHiding.remove(entry);
            }
            if (category.getEntries().size() == entriesAfterHiding.size()) continue;
            category.setEntries(entriesAfterHiding);
        }
        return rslt;
    }

    public boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return this.enclosedNotificationService.isValid(req, previousResponse);
    }
}

