/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.ssp;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.notice.service.ssp.ISSPApi;
import org.jasig.portlet.notice.service.ssp.SSPApiRequest;
import org.jasig.portlet.notice.service.ssp.SSPToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class SSPApi
implements ISSPApi {
    private static final String AUTHORIZATION = "authorization";
    private static final String BASIC = "Basic";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private RestTemplate restTemplate;
    private String clientId;
    private String clientSecret;
    private String authenticationUrl = "/api/1/oauth2/token";
    private String sspProtocol = "https";
    private String sspHost = "locahost";
    private int sspPort = 443;
    private String sspContext = "/ssp";
    private SSPToken authenticationToken;

    @Autowired
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Value(value="${studentSuccessPlanService.clientId:}")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Value(value="${studentSuccessPlanService.clientSecret:}")
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Value(value="${studentSuccessPlanService.authenticationUrl:/api/1/oauth2/token}")
    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    @Value(value="${studentSuccessPlanService.sspProtocol:https}")
    public void setSspProtocol(String sspProtocol) {
        Validate.isTrue((sspProtocol.equalsIgnoreCase("http") || sspProtocol.equalsIgnoreCase("https") ? 1 : 0) != 0, (String)"sspProtocol must be set to either 'http' or 'https'");
        this.sspProtocol = sspProtocol;
    }

    @Value(value="${studentSuccessPlanService.sspHost:}")
    public void setSspHost(String sspHost) {
        this.sspHost = sspHost;
    }

    @Value(value="${studentSuccessPlanService.sspPort:443}")
    public void setSspPort(int sspPort) {
        this.sspPort = sspPort;
    }

    @Value(value="${studentSuccessPlanService.sspContext:/ssp}")
    public void setSspContext(String sspContext) {
        if (!sspContext.startsWith("/")) {
            sspContext = "/" + sspContext;
        }
        if (sspContext.endsWith("/")) {
            sspContext = sspContext.replaceAll("/*$", "");
        }
        this.sspContext = sspContext;
    }

    public <T> ResponseEntity<T> doRequest(SSPApiRequest<T> request) throws MalformedURLException, RestClientException {
        SSPToken token = this.getAuthenticationToken(false);
        request.setHeader(AUTHORIZATION, token.getTokenType() + " " + token.getAccessToken());
        URL url = this.getSSPUrl(request.getUrlFragment(), true);
        ResponseEntity response = this.restTemplate.exchange(url.toExternalForm(), request.getMethod(), request.getRequestEntity(), request.getResponseClass(), request.getUriParameters());
        if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            token = this.getAuthenticationToken(true);
            request.setHeader(AUTHORIZATION, token.getTokenType() + " " + token.getAccessToken());
            return this.restTemplate.exchange(url.toExternalForm(), request.getMethod(), request.getRequestEntity(), request.getResponseClass(), request.getUriParameters());
        }
        return response;
    }

    public URL getSSPUrl(String urlFragment, boolean useContext) throws MalformedURLException {
        String path = useContext ? this.sspContext + urlFragment : urlFragment;
        return new URL(this.sspProtocol, this.sspHost, this.sspPort, path);
    }

    private synchronized SSPToken getAuthenticationToken(boolean forceUpdate) throws MalformedURLException, RestClientException {
        if (this.authenticationToken != null && !this.authenticationToken.hasExpired() && !forceUpdate) {
            return this.authenticationToken;
        }
        String authString = this.getClientId() + ":" + this.getClientSecret();
        String authentication = new Base64().encodeToString(authString.getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.add(AUTHORIZATION, "Basic " + authentication);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)GRANT_TYPE, (Object)CLIENT_CREDENTIALS);
        HttpEntity request = new HttpEntity((Object)form, (MultiValueMap)headers);
        URL authURL = this.getAuthenticationURL();
        this.authenticationToken = (SSPToken)this.restTemplate.postForObject(authURL.toExternalForm(), (Object)request, SSPToken.class, new Object[0]);
        return this.authenticationToken;
    }

    private String getClientId() {
        return this.clientId;
    }

    private String getClientSecret() {
        return this.clientSecret;
    }

    private URL getAuthenticationURL() throws MalformedURLException {
        return this.getSSPUrl(this.authenticationUrl, true);
    }
}

