/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.event;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.NotificationConstants;
import org.jasig.portlet.notice.NotificationQuery;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationResult;
import org.jasig.portlet.notice.service.AbstractNotificationService;

public final class PortletEventNotificationService
extends AbstractNotificationService {
    private final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;

    @Resource(name="PortletEventNotificationService.responseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        PortletPreferences prefs = req.getPreferences();
        boolean doEvents = Boolean.parseBoolean(prefs.getValue("NotificationLifecycleController.doEvents", "false"));
        if (doEvents) {
            String cacheKey = this.createServiceUserWindowSpecificCacheKey((PortletRequest)req);
            boolean sendRequestEvent = false;
            if (refresh) {
                this.cache.remove((Serializable)((Object)cacheKey));
                sendRequestEvent = true;
            } else {
                Element m = this.cache.get((Serializable)((Object)cacheKey));
                if (m == null) {
                    sendRequestEvent = true;
                }
            }
            if (sendRequestEvent) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("REQUESTING Notifications events for user='" + this.usernameFinder.findUsername((PortletRequest)req) + "' and windowId=" + req.getWindowID()));
                }
                NotificationQuery query = new NotificationQuery();
                query.setQueryWindowId(req.getWindowID());
                res.setEvent(NotificationConstants.NOTIFICATION_QUERY_QNAME, (Serializable)query);
            }
        }
    }

    public void collect(EventRequest req, EventResponse res) {
        String cacheKey;
        Element m;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RECEIVING Notifications events for user='" + this.usernameFinder.findUsername((PortletRequest)req) + "' and windowId=" + req.getWindowID()));
        }
        HashMap responses = (m = this.cache.get((Serializable)((Object)(cacheKey = this.createServiceUserWindowSpecificCacheKey((PortletRequest)req))))) == null ? new HashMap() : (HashMap)m.getObjectValue();
        NotificationResult notificationResult = (NotificationResult)req.getEvent().getValue();
        responses.put(notificationResult.getResultWindowId(), notificationResult.getNotificationResponse());
        this.cache.put(new Element((Serializable)((Object)cacheKey), (Serializable)responses));
    }

    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        String cacheKey = this.createServiceUserWindowSpecificCacheKey(req);
        Element m = this.cache.get((Serializable)((Object)cacheKey));
        if (m != null) {
            Map map = (Map)m.getObjectValue();
            for (NotificationResponse response : map.values()) {
                rslt = rslt.combine(response);
            }
        }
        return rslt;
    }
}

