/*
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.notice.service.filter;

import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;

/**
 * Encapsulates a single rule that chooses whether a notification stays or goes inside the
 * {@link FilteringNotificationServiceDecorator};  rules may be combined.
 *
 * @since 3.1
 */
public interface INotificationFilter {

    /**
     * Decides whether a {@link NotificationEntry} stays or goes.
     *
     * @param category The {@link NotificationCategory} to which the entry belongs
     * @param entry The {@link NotificationEntry} that may or may not survive
     * @return <code>true</code> if the entry should survive, otherwise <code>false</code>
     */
    boolean doFilter(NotificationCategory category, NotificationEntry entry);

}
