/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jdbc;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.sql.DataSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.jdbc.AbstractJdbcNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class AbstractJdbcNotificationService
extends AbstractNotificationService {
    private DataSource dataSource;
    private String sql;
    private Cache cache;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private Set<String> requiredParameters = Collections.emptySet();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Required
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Resource(name="AbstractJdbcNotificationService.responseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setRequiredParameters(Set<String> requiredParameters) {
        this.requiredParameters = Collections.unmodifiableSet(requiredParameters);
    }

    @PostConstruct
    public void init() {
        this.logger.debug("Initializing AbstractJdbcNotificationService where name={}", (Object)this.getName());
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        String username = this.usernameFinder.findUsername((PortletRequest)req);
        this.logger.debug("Performing AbstractJdbcNotificationService.invoke() for user='{}' refresh={}", (Object)username, (Object)refresh);
        if (refresh) {
            CacheKey cacheKey = new CacheKey(this.getName(), username, this.sql);
            this.cache.remove((Serializable)cacheKey);
        }
    }

    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse rslt;
        String username = this.usernameFinder.findUsername(req);
        CacheKey cacheKey = new CacheKey(this.getName(), username, this.sql);
        Element m = this.cache.get((Serializable)cacheKey);
        if (m != null) {
            rslt = (NotificationResponse)m.getObjectValue();
            this.logger.debug("Found the following response for user='{}' from cache:  {}", (Object)username, (Object)rslt);
        } else {
            SqlParameterSource sqlParameterSource = this.getSqlParameterSource(req);
            ResultSetExtractor resultSetExtractor = this.getResultSetExtractor(req);
            boolean hasAllParameters = true;
            for (String parameter : this.requiredParameters) {
                if (sqlParameterSource.hasValue(parameter)) continue;
                this.logger.debug("Skipping notification service='{}' for user='{}' because required parameter '{}' was not present", new Object[]{this.getName(), username, parameter});
                hasAllParameters = false;
                break;
            }
            rslt = hasAllParameters ? (NotificationResponse)this.jdbcTemplate.query(this.sql, sqlParameterSource, resultSetExtractor) : NotificationResponse.EMPTY_RESPONSE;
            this.cache.put(new Element((Serializable)cacheKey, (Serializable)rslt));
            this.logger.debug("Notification service '{}' generated the following responsefor user='{}':  {}", new Object[]{this.getName(), username, rslt});
        }
        return rslt;
    }

    protected SqlParameterSource getSqlParameterSource(PortletRequest req) {
        return EmptySqlParameterSource.INSTANCE;
    }

    protected abstract ResultSetExtractor<NotificationResponse> getResultSetExtractor(PortletRequest var1);
}

