/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationServiceDecorator;
import org.jasig.portlet.notice.service.filter.INotificationFilter;
import org.jasig.portlet.notice.service.filter.MaximumPriorityNotificationFilter;
import org.jasig.portlet.notice.service.filter.MinimumPriorityNotificationFilter;
import org.jasig.portlet.notice.service.filter.RequiredRoleNotificationFilter;
import org.jasig.portlet.notice.util.PortletXmlRoleService;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FilteringNotificationServiceDecorator
extends AbstractNotificationServiceDecorator {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String PORTLET_XML_ROLE_SERVICE_ATTRIBUTE = "FilteringNotificationServiceDecorator.portletXmlRoleService";
    private INotificationService enclosedNotificationService;
    private UsernameFinder usernameFinder;
    private PortletXmlRoleService portletXmlRoleService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public void setUsernameFinder(UsernameFinder usernameFinder) {
        this.usernameFinder = usernameFinder;
    }

    @Autowired
    public void setPortletXmlRoleService(PortletXmlRoleService portletXmlRoleService) {
        this.portletXmlRoleService = portletXmlRoleService;
    }

    public void setEnclosedNotificationService(INotificationService enclosedNotificationService) {
        this.enclosedNotificationService = enclosedNotificationService;
    }

    @Override
    public String getName() {
        return this.enclosedNotificationService.getName();
    }

    @Override
    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.enclosedNotificationService.invoke(req, res, refresh);
    }

    @Override
    public void collect(EventRequest req, EventResponse res) {
        this.enclosedNotificationService.collect(req, res);
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse unfilteredResponse = this.enclosedNotificationService.fetch(req);
        HashSet<INotificationFilter> filters = new HashSet<INotificationFilter>();
        req.setAttribute(PORTLET_XML_ROLE_SERVICE_ATTRIBUTE, (Object)this.portletXmlRoleService);
        for (FilterMapper mapper : FilterMapper.values()) {
            filters.addAll(mapper.fromPortletRequest(req));
        }
        if (filters.size() == 0) {
            this.logger.debug("No INotificationFilter objects apply to notifications for username='{}' and windowID='{}'", (Object)this.usernameFinder.findUsername(req), (Object)req.getWindowID());
            return unfilteredResponse;
        }
        this.logger.debug("Found the following INotificationFilter objects for username='{}' and windowID='{}':  {}", new Object[]{this.usernameFinder.findUsername(req), req.getWindowID(), filters});
        ArrayList<NotificationCategory> filteredCategories = new ArrayList<NotificationCategory>();
        for (NotificationCategory unfilteredCategory : unfilteredResponse.getCategories()) {
            ArrayList<NotificationEntry> filteredEntries = new ArrayList<NotificationEntry>();
            for (NotificationEntry entry : unfilteredCategory.getEntries()) {
                boolean excluded = false;
                for (INotificationFilter filter : filters) {
                    if (filter.doFilter(unfilteredCategory, entry)) continue;
                    excluded = true;
                    break;
                }
                if (excluded) continue;
                filteredEntries.add(entry);
            }
            if (filteredEntries.size() == 0) continue;
            NotificationCategory category = new NotificationCategory();
            category.setTitle(unfilteredCategory.getTitle());
            category.setEntries(filteredEntries);
            filteredCategories.add(category);
        }
        NotificationResponse rslt = new NotificationResponse();
        rslt.setCategories(filteredCategories);
        rslt.setErrors(unfilteredResponse.getErrors());
        return rslt;
    }

    @Override
    public boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return this.enclosedNotificationService.isValid(req, previousResponse);
    }

    private static enum FilterMapper {
        MINIMUM_PRIORITY{
            private static final String PREFERENCE_NAME = "FilteringNotificationServiceDecorator.minPriority";

            @Override
            Set<INotificationFilter> fromPortletRequest(PortletRequest req) {
                String[] preferenceValues = req.getPreferences().getValues(PREFERENCE_NAME, EMPTY_STRING_ARRAY);
                if (preferenceValues.length != 0) {
                    int priority = Integer.valueOf(preferenceValues[0]);
                    return Collections.singleton(new MinimumPriorityNotificationFilter(priority));
                }
                return Collections.emptySet();
            }
        }
        ,
        MAXIMUM_PRIORITY{
            private static final String PREFERENCE_NAME = "FilteringNotificationServiceDecorator.maxPriority";

            @Override
            Set<INotificationFilter> fromPortletRequest(PortletRequest req) {
                String[] preferenceValues = req.getPreferences().getValues(PREFERENCE_NAME, EMPTY_STRING_ARRAY);
                if (preferenceValues.length != 0) {
                    int priority = Integer.valueOf(preferenceValues[0]);
                    return Collections.singleton(new MaximumPriorityNotificationFilter(priority));
                }
                return Collections.emptySet();
            }
        }
        ,
        REQUIRED_ROLE{
            private static final String PREFERENCE_NAME = "FilteringNotificationServiceDecorator.requiredRole";

            @Override
            Set<INotificationFilter> fromPortletRequest(PortletRequest req) {
                String[] preferenceValues = req.getPreferences().getValues(PREFERENCE_NAME, EMPTY_STRING_ARRAY);
                if (preferenceValues.length != 0 && Boolean.valueOf(preferenceValues[0]).booleanValue()) {
                    HashSet<String> userRoles = new HashSet<String>();
                    PortletXmlRoleService portletXmlRoleService = (PortletXmlRoleService)req.getAttribute(FilteringNotificationServiceDecorator.PORTLET_XML_ROLE_SERVICE_ATTRIBUTE);
                    for (String definedRole : portletXmlRoleService.getAllRoles()) {
                        if (!req.isUserInRole(definedRole)) continue;
                        userRoles.add(definedRole);
                    }
                    return Collections.singleton(new RequiredRoleNotificationFilter(userRoles));
                }
                return Collections.emptySet();
            }
        };


        abstract Set<INotificationFilter> fromPortletRequest(PortletRequest var1);
    }
}

