/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rest.IParameterEvaluator;
import org.jasig.portlet.notice.service.rest.RestfulJsonNotificationService;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public final class RestfulJsonNotificationService
extends AbstractNotificationService {
    private static final String SERVICE_URLS_PREFERENCE = "RestfulJsonNotificationService.serviceUrls";
    private final ResponseExtractor<NotificationResponse> responseExtractor = new ResponseExtractorImpl(this, null);
    private IParameterEvaluator usernameEvaluator = null;
    private IParameterEvaluator passwordEvaluator = null;
    private Map<String, IParameterEvaluator> urlParameters;
    private RestTemplate restTemplate;
    @Value(value="${RestfulJsonNotificationService.serviceUrls:}")
    private String serviceUrlsProperty;
    private List<String> serviceUrlsList = Collections.emptyList();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;

    @Required
    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    @Required
    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    @Autowired
    public void setUrlParameterEvaluators(Set<IParameterEvaluator> evaluators) {
        HashMap map = new HashMap();
        evaluators.forEach(evaluator -> map.put(evaluator.getToken(), evaluator));
        this.urlParameters = Collections.unmodifiableMap(map);
        this.logger.info("Found the following IParameterEvaluator beans:  {}", (Object)this.urlParameters);
    }

    @Required
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.serviceUrlsProperty)) {
            this.serviceUrlsList = Collections.unmodifiableList(Arrays.asList(this.serviceUrlsProperty.split(",")));
        }
    }

    public NotificationResponse fetch(PortletRequest req) {
        return this.fetchFromServiceUrls(this.getServiceUrls(req), (RequestCallback)new RequestCallbackImpl(this, (Object)req), this.usernameFinder.findUsername(req), this.createParameters(req));
    }

    public NotificationResponse fetch(HttpServletRequest req) {
        return this.fetchFromServiceUrls(this.getServiceUrls(), (RequestCallback)new RequestCallbackImpl(this, (Object)req), this.usernameFinder.findUsername(req), this.createParameters(req));
    }

    @Deprecated
    private List<String> getServiceUrls(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] urls = prefs.getValues(SERVICE_URLS_PREFERENCE, new String[0]);
        return new ArrayList<String>(Arrays.asList(urls));
    }

    private List<String> getServiceUrls() {
        return this.serviceUrlsList;
    }

    private NotificationResponse fetchFromServiceUrls(List<String> serviceUrls, RequestCallback requestCallback, String username, Map<String, String> params) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        for (String url : serviceUrls) {
            this.logger.debug("Invoking uri '{}' with the following parameters:  {}", (Object)url, params);
            try {
                NotificationResponse response = (NotificationResponse)this.restTemplate.execute(url, HttpMethod.GET, requestCallback, this.responseExtractor, params);
                rslt = rslt.combine(response);
            }
            catch (Exception e) {
                String msg = "Failed to invoke the following service at '" + url + "' for user " + username;
                this.logger.error(msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), "Service Unavailable");
            }
        }
        return rslt;
    }

    @Deprecated
    private Map<String, String> createParameters(PortletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry y : this.urlParameters.entrySet()) {
            String key = (String)y.getKey();
            String value = ((IParameterEvaluator)this.urlParameters.get(key)).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    private Map<String, String> createParameters(HttpServletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry y : this.urlParameters.entrySet()) {
            String key = (String)y.getKey();
            String value = ((IParameterEvaluator)this.urlParameters.get(key)).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    static /* synthetic */ IParameterEvaluator access$100(RestfulJsonNotificationService x0) {
        return x0.usernameEvaluator;
    }

    static /* synthetic */ IParameterEvaluator access$200(RestfulJsonNotificationService x0) {
        return x0.passwordEvaluator;
    }

    static /* synthetic */ Logger access$300(RestfulJsonNotificationService x0) {
        return x0.logger;
    }
}

