/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.sort.SortOrder;
import org.jasig.portlet.notice.util.sort.SortStrategy;

public final class Sorting {
    public static final String SORT_STRATEGY_PREFERENCE = "Sorting.sortStrategy";
    public static final String SORT_ORDER_PREFERENCE = "Sorting.sortOrder";
    public static final String SORT_ORDER_DEFAULT = SortOrder.ASCENDING.name();

    public static NotificationResponse sort(PortletRequest req, NotificationResponse data) {
        Comparator<NotificationEntry> comparator = Sorting.chooseConfiguredComparator(req);
        if (comparator == null) {
            return data;
        }
        ArrayList<NotificationCategory> copies = new ArrayList<NotificationCategory>();
        for (NotificationCategory category : data.getCategories()) {
            ArrayList entries = new ArrayList(category.getEntries());
            Collections.sort(entries, comparator);
            copies.add(new NotificationCategory(category.getTitle(), entries));
        }
        return new NotificationResponse(copies, data.getErrors());
    }

    public static List<NotificationEntry> sort(PortletRequest req, List<NotificationEntry> entries) {
        Comparator<NotificationEntry> comparator = Sorting.chooseConfiguredComparator(req);
        if (comparator == null) {
            return entries;
        }
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>(entries);
        Collections.sort(rslt, comparator);
        return rslt;
    }

    private static Comparator<NotificationEntry> chooseConfiguredComparator(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String strategyName = prefs.getValue(SORT_STRATEGY_PREFERENCE, null);
        if (strategyName == null) {
            return null;
        }
        SortStrategy strategy = SortStrategy.valueOf(strategyName);
        String orderName = prefs.getValue(SORT_ORDER_PREFERENCE, SORT_ORDER_DEFAULT);
        SortOrder order = SortOrder.valueOf(orderName);
        return order.equals((Object)SortOrder.ASCENDING) ? strategy.getComparator() : Collections.reverseOrder(strategy.getComparator());
    }
}

