/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portlet.notice.INotificationRepository;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.INotificationServiceFilter;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.IRefreshable;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NotificationServiceFilterConfiguration {
    @Autowired
    private List<INotificationServiceFilter> filters;
    @Autowired
    private Set<INotificationService> services;
    @Autowired
    private UsernameFinder usernameFinder;
    private static final Logger logger = LoggerFactory.getLogger(NotificationServiceFilterConfiguration.class);

    @Bean(value={"notificationRepository"})
    public INotificationRepository notificationRepository() {
        return new NotificationRepositoryImpl(this.filters, this.services, this.usernameFinder);
    }

    private static class NotificationServiceFilterChainImpl
    implements INotificationServiceFilterChain {
        private final INotificationServiceFilter filter;
        private final HttpServletRequest request;
        private final INotificationServiceFilterChain nextLink;

        NotificationServiceFilterChainImpl(INotificationServiceFilter filter, HttpServletRequest request, INotificationServiceFilterChain nextLink) {
            this.filter = filter;
            this.request = request;
            this.nextLink = nextLink;
        }

        @Override
        public NotificationResponse doFilter() {
            NotificationResponse rslt = this.filter.doFilter(this.request, this.nextLink);
            logger.debug("Processing INotificationServiceFilter bean '{}';  size={}", (Object)this.filter, (Object)rslt.size());
            return rslt;
        }
    }

    private static class NotificationRepositoryImpl
    implements INotificationRepository {
        private final List<INotificationServiceFilter> sortedFilters;
        private final Set<INotificationService> services;
        private final UsernameFinder usernameFinder;

        NotificationRepositoryImpl(List<INotificationServiceFilter> filters, Set<INotificationService> services, UsernameFinder usernameFinder) {
            ArrayList<INotificationServiceFilter> filtersCopy = new ArrayList<INotificationServiceFilter>(filters);
            Collections.sort(filtersCopy);
            logger.info("Found the following INotificationServiceFilter beans in the following sequence:  {}", filtersCopy);
            Collections.reverse(filtersCopy);
            this.sortedFilters = Collections.unmodifiableList(filtersCopy);
            logger.info("Found the following INotificationService beans:  {}", services);
            this.services = services;
            this.usernameFinder = usernameFinder;
        }

        @Override
        public void refresh(HttpServletRequest request, HttpServletResponse response) {
            for (INotificationService service : this.services) {
                if (!IRefreshable.class.isInstance(service)) continue;
                logger.debug("Refreshing INotificationService bean '{}'", (Object)service.getName());
                ((IRefreshable)((Object)service)).refresh(request, response);
            }
            for (INotificationServiceFilter filter : this.sortedFilters) {
                if (!IRefreshable.class.isInstance(filter)) continue;
                logger.debug("Refreshing INotificationServiceFilter bean '{}'", (Object)filter);
                ((IRefreshable)((Object)filter)).refresh(request, response);
            }
        }

        @Override
        public NotificationResponse fetch(HttpServletRequest request) {
            String username = this.usernameFinder.findUsername(request);
            logger.debug("Fetching notifications on behalf of user '{}'", (Object)username);
            INotificationServiceFilterChain chain = () -> {
                NotificationResponse rslt = new NotificationResponse();
                for (INotificationService service : this.services) {
                    NotificationResponse response = service.fetch(request);
                    rslt = rslt.combine(response);
                    logger.debug("Processed INotificationService bean '{}';  size={}", (Object)service.getName(), (Object)rslt.size());
                }
                return rslt;
            };
            for (INotificationServiceFilter filter : this.sortedFilters) {
                chain = new NotificationServiceFilterChainImpl(filter, request, chain);
            }
            return chain.doFilter();
        }
    }
}

