/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.ssp;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.service.ssp.ISSPApi;
import org.jasig.portlet.notice.service.ssp.ISSPPersonLookup;
import org.jasig.portlet.notice.service.ssp.SSPApiRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

public class SSPSchoolIdPersonLookup
implements ISSPPersonLookup {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String USERNAME_ATTRIBUTE = "user.login.id";
    private static final String SUCCESS_QUERY = "$.success";
    private static final String RESULTS_QUERY = "$.results";
    private static final String STUDENT_ID_QUERY = "$.rows[0].id";
    private String personSearchURL = "/api/1/person/directoryperson/search?limit=2&schoolId={schoolId}&start=0";
    private ISSPApi sspApi;
    private Cache cache;

    @Resource(name="StudentSuccessPlanService.schoolIdToPersonIdCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Autowired
    public void setSspApi(ISSPApi sspApi) {
        this.sspApi = sspApi;
    }

    @Override
    public String lookupPersonId(PortletRequest request) {
        String studentId = this.getSchoolId(request);
        if (StringUtils.isBlank((String)studentId)) {
            return null;
        }
        Element element = this.cache.get((Serializable)((Object)studentId));
        if (element != null) {
            return (String)element.getObjectValue();
        }
        String url = this.getPersonSearchURL();
        SSPApiRequest sspReq = new SSPApiRequest<String>(url, String.class).addUriParameter("schoolId", studentId);
        try {
            ResponseEntity response = this.sspApi.doRequest(sspReq);
            String userId = this.extractUserId(studentId, response);
            Element cacheElement = new Element((Serializable)((Object)studentId), (Serializable)((Object)userId));
            this.cache.put(cacheElement);
            return userId;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getSchoolId(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        String schoolIdAttributeName = prefs.getValue("SSPTaskNotificationService.schoolIdAttribute", "schoolId");
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String studentId = (String)userInfo.get(schoolIdAttributeName);
        if (!StringUtils.isEmpty((String)studentId)) {
            return studentId;
        }
        studentId = (String)userInfo.get(USERNAME_ATTRIBUTE);
        return studentId;
    }

    private String extractUserId(String studentId, ResponseEntity<String> response) {
        Configuration config = Configuration.builder().options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).build();
        DocumentContext readContext = JsonPath.using((Configuration)config).parse((String)response.getBody());
        String success = (String)readContext.read(SUCCESS_QUERY, new Predicate[0]);
        if (!"true".equalsIgnoreCase(success)) {
            return null;
        }
        int count = (Integer)readContext.read(RESULTS_QUERY, Integer.class, new Predicate[0]);
        if (count != 1) {
            this.log.warn("Expected a single unique result for " + studentId + ".  Found " + count);
            return null;
        }
        String id = (String)readContext.read(STUDENT_ID_QUERY, new Predicate[0]);
        return id;
    }

    private String getPersonSearchURL() {
        return this.personSearchURL;
    }
}

