/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.filter.AbstractNotificationServiceFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Component;

@Component
public class ApiUrlSupportFilter
extends AbstractNotificationServiceFilter {
    private static final String REST_API_URL_FORMAT = "%s/api/v2/action/%s/%s?_csrf=%s";

    public ApiUrlSupportFilter() {
        super(-100);
    }

    public NotificationResponse doFilter(HttpServletRequest request, INotificationServiceFilterChain chain) {
        NotificationResponse response = chain.doFilter();
        NotificationResponse rslt = response.cloneIfNotCloned();
        for (NotificationCategory category : rslt.getCategories()) {
            for (NotificationEntry entry : category.getEntries()) {
                List actions = entry.getAvailableActions().stream().map(action -> {
                    if (StringUtils.isNotBlank((CharSequence)action.getId()) && action.getTarget() != null && StringUtils.isNotBlank((CharSequence)action.getTarget().getId())) {
                        String requestUrl = request.getRequestURL().toString();
                        String contextPath = request.getContextPath();
                        String urlBase = requestUrl.substring(0, requestUrl.indexOf(contextPath)) + contextPath;
                        CsrfToken csrf = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
                        String apiUrl = String.format(REST_API_URL_FORMAT, urlBase, action.getId(), action.getTarget().getId(), csrf != null ? csrf.getToken() : null);
                        action.setApiUrl(apiUrl);
                    }
                    return action;
                }).collect(Collectors.toList());
                entry.setAvailableActions(actions);
            }
        }
        return rslt;
    }
}

