/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.jdbc.AbstractJdbcNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.ResultSetExtractor;

public class AnyRowResourceContentJdbcNotificationService
extends AbstractJdbcNotificationService {
    private Resource jsonResource;
    private ObjectMapper objectMapper = new ObjectMapper();
    private NotificationResponse nonEmptyResponse;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setJsonResource(Resource jsonResource) {
        this.jsonResource = jsonResource;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        try {
            this.nonEmptyResponse = (NotificationResponse)this.objectMapper.readValue(this.jsonResource.getURL(), NotificationResponse.class);
        }
        catch (IOException ioe) {
            String msg = "Failed to load JSON from resource:  " + this.jsonResource;
            throw new RuntimeException(msg, ioe);
        }
    }

    @Override
    protected ResultSetExtractor<NotificationResponse> getResultSetExtractor(PortletRequest req) {
        return this.getResultSetExtractor();
    }

    @Override
    protected ResultSetExtractor<NotificationResponse> getResultSetExtractor(HttpServletRequest request) {
        return this.getResultSetExtractor();
    }

    private ResultSetExtractor<NotificationResponse> getResultSetExtractor() {
        return rs -> {
            if (rs.next()) {
                this.logger.debug("ResultSet NOT empty for notification service '{}'", (Object)this.getName());
                return this.nonEmptyResponse;
            }
            this.logger.debug("ResultSet empty for notification service '{}'", (Object)this.getName());
            return NotificationResponse.EMPTY_RESPONSE;
        };
    }
}

