/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.jasig.portlet.notice.service.jpa.JpaEntry;

@Entity
@Table(name="NOTICE_ATTRIBUTE")
class JpaAttribute {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    private long id;
    @ManyToOne
    @JoinColumn(name="ENTRY_ID")
    private JpaEntry entry;
    @Column(name="NAME", nullable=false)
    private String name;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="NOTICE_ATTRIBUTE_VALUES")
    @Column(name="VAL")
    private List<String> values = new ArrayList<String>();

    JpaAttribute() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public JpaEntry getEntry() {
        return this.entry;
    }

    public void setEntry(JpaEntry entry) {
        this.entry = entry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValues(List<String> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void addValue(int index, String value) {
        this.values.add(index, value);
    }

    public String toString() {
        return "JpaAttribute [id=" + this.id + ", name=" + this.name + ", values=" + this.values + "]";
    }
}

