/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.springframework.stereotype.Component;

@Component
public class NotificationResponseFlattener {
    public List<NotificationEntry> flatten(NotificationResponse response) {
        NotificationResponse clone = response.cloneIfNotCloned();
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>();
        HashSet<String> categoryList = new HashSet<String>();
        for (NotificationCategory notificationCategory : clone.getCategories()) {
            categoryList.add(notificationCategory.getTitle());
            this.addAndCategorizeEntries(rslt, notificationCategory);
        }
        return rslt;
    }

    private void addAndCategorizeEntries(List<NotificationEntry> allEntries, NotificationCategory notificationCategory) {
        for (NotificationEntry entry : notificationCategory.getEntries()) {
            ArrayList<NotificationAttribute> attrs = new ArrayList<NotificationAttribute>(entry.getAttributes());
            attrs.add(new NotificationAttribute("category", notificationCategory.getTitle()));
            entry.setAttributes(attrs);
            allEntries.add(entry);
        }
    }
}

