/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.hide;

import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.action.hide.HideAction;
import org.jasig.portlet.notice.action.hide.ShortDurationHideAction;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.util.JpaServices;
import org.jasig.portlet.notice.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShortDurationHideAction
extends HideAction {
    private static final long serialVersionUID = 1L;
    private final long hideDurationMillis;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ShortDurationHideAction(long hideDurationMillis) {
        this.hideDurationMillis = hideDurationMillis;
    }

    boolean isEntrySnoozed(NotificationEntry entry, PortletRequest req) {
        if (StringUtils.isBlank((String)entry.getId())) {
            return false;
        }
        boolean rslt = false;
        JpaServices jpaServices = (JpaServices)SpringContext.getApplicationContext().getBean("jpaServices");
        List history = jpaServices.getHistory(entry, req.getRemoteUser());
        this.logger.debug("List<EventDTO> within getNotificationsBySourceAndCustomAttribute contains {} elements", (Object)history.size());
        for (EventDTO event : history) {
            switch (1.$SwitchMap$org$jasig$portlet$notice$NotificationState[event.getState().ordinal()]) {
                case 1: {
                    this.logger.debug("Found a SNOOZED event:  {}", (Object)event);
                    if (event.getTimestamp().getTime() + this.hideDurationMillis <= System.currentTimeMillis()) break;
                    rslt = true;
                    break;
                }
                case 2: {
                    this.logger.debug("Found an ISSUED event:  {}", (Object)event);
                    rslt = false;
                    break;
                }
            }
        }
        this.logger.debug("Returning SNOOZED='{}' for the following notification:  {}", (Object)rslt, (Object)entry);
        return rslt;
    }
}

