/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.rest.AddresseeDTO;
import org.jasig.portlet.notice.rest.EntryDTO;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.rest.RecipientDTO;
import org.jasig.portlet.notice.service.jpa.IJpaNotificationRESTService;
import org.jasig.portlet.notice.service.jpa.INotificationDTOMapper;
import org.jasig.portlet.notice.service.jpa.INotificationDao;
import org.jasig.portlet.notice.service.jpa.JpaAddressee;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.jasig.portlet.notice.service.jpa.JpaEvent;
import org.jasig.portlet.notice.util.JpaServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jpaNotificationRestService")
public class JpaNotificationRESTService
implements IJpaNotificationRESTService {
    @Autowired
    private INotificationDao notificationDao;
    @Autowired
    private INotificationDTOMapper notificationMapper;
    @Autowired
    private JpaServices jpaServices;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional(readOnly=true)
    public EntryDTO getNotification(long id, boolean full) {
        JpaEntry entry;
        JpaEntry jpaEntry = entry = full ? this.notificationDao.getFullEntry(id) : this.notificationDao.getEntry(id);
        if (entry == null) {
            return null;
        }
        return this.notificationMapper.toEntry(entry);
    }

    @Transactional(readOnly=true)
    public EntryDTO getNotification(NotificationEntry entry, boolean full) {
        EntryDTO rslt = null;
        if (this.jpaServices.contains(entry)) {
            String idString = entry.getId().substring("jpa_".length());
            long id = Long.parseLong(idString);
            rslt = this.getNotification(id, full);
        }
        return rslt;
    }

    @Transactional(readOnly=true)
    public List<EntryDTO> getNotifications(Integer page, Integer pageSize) {
        List entries = this.notificationDao.list(page, pageSize);
        return this.notificationMapper.toEntryList(entries);
    }

    @Transactional(readOnly=true)
    public List<EntryDTO> getNotificationsBySourceAndCustomAttribute(String source, String attributeName, String attributeValue) {
        Validate.notBlank((CharSequence)source, (String)"Argument 'source' cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attributeName, (String)"Argument 'attributeName' cannot be blank", (Object[])new Object[0]);
        this.logger.debug("Invoking getNotificationsBySourceAndCustomAttribute with source='{}', attributeName='{}', attributeValue='{}'", new Object[]{source, attributeName, attributeValue});
        List entries = this.notificationDao.getNotificationsBySourceAndCustomAttribute(source, attributeName, attributeValue);
        this.logger.debug("Found the following {} entries:  {}", (Object)entries.size(), (Object)entries);
        return this.notificationMapper.toEntryList(entries);
    }

    @Transactional
    public EntryDTO createNotification(EntryDTO entry) {
        Validate.isTrue((entry.getId() == 0L ? 1 : 0) != 0, (String)"Do not include an 'id' attribute when creating entries", (Object[])new Object[0]);
        JpaEntry jpaEntry = this.notificationMapper.toJpaEntry(entry);
        this.logger.debug("notificationMapper produced the following JpaEntry:  {}", (Object)jpaEntry);
        JpaEntry inserted = this.notificationDao.createOrUpdateEntry(jpaEntry);
        return this.notificationMapper.toEntry(inserted);
    }

    @Transactional(readOnly=true)
    public Set<AddresseeDTO> getAddressees(long notificationId) {
        JpaEntry jpaEntry = this.notificationDao.getFullEntry(notificationId);
        if (jpaEntry == null) {
            return null;
        }
        return this.notificationMapper.toAddresseeSet(jpaEntry.getAddressees());
    }

    @Transactional(readOnly=true)
    public AddresseeDTO getAddressee(long addresseeId) {
        JpaAddressee addr = this.notificationDao.getAddressee(addresseeId);
        if (addr == null) {
            return null;
        }
        return this.notificationMapper.toAddressee(addr);
    }

    @Transactional
    public AddresseeDTO createAddressee(long notificationId, AddresseeDTO addressee) {
        Validate.isTrue((addressee.getId() == 0L ? 1 : 0) != 0, (String)"Do not include an 'id' attribute when creating addressees", (Object[])new Object[0]);
        for (RecipientDTO r : addressee.getRecipients()) {
            Validate.isTrue((r.getId() == 0L ? 1 : 0) != 0, (String)"Do not include an 'id' attribute on recipients when creating addressees", (Object[])new Object[0]);
        }
        JpaEntry entry = this.notificationDao.getEntry(notificationId);
        if (entry == null) {
            return null;
        }
        JpaAddressee jpa = this.notificationMapper.toJpaAddressee(addressee);
        entry.addAddressee(jpa);
        JpaAddressee persisted = this.notificationDao.createOrUpdateAddressee(jpa);
        return this.notificationMapper.toAddressee(persisted);
    }

    @Transactional(readOnly=true)
    public List<EventDTO> getEventsByNotification(long notificationId) {
        List events = this.notificationDao.getEvents(notificationId);
        return this.notificationMapper.toEventList(events);
    }

    @Transactional(readOnly=true)
    public List<EventDTO> getEventsByNotificationAndUser(long notificationId, String username) {
        List events = this.notificationDao.getEvents(notificationId, username);
        return this.notificationMapper.toEventList(events);
    }

    @Transactional(readOnly=true)
    public EventDTO getEvent(long eventId) {
        JpaEvent event = this.notificationDao.getEvent(eventId);
        if (event == null) {
            return null;
        }
        return this.notificationMapper.toEvent(event);
    }

    @Transactional
    public EventDTO createEvent(long notificationId, EventDTO event) {
        Validate.isTrue((event.getId() == 0L ? 1 : 0) != 0, (String)"Do not include an 'id' attribute when creating events", (Object[])new Object[0]);
        JpaEntry entry = this.notificationDao.getEntry(notificationId);
        JpaEvent jpa = this.notificationMapper.toJpaEvent(event);
        jpa.setEntry(entry);
        JpaEvent jpaResult = this.notificationDao.createOrUpdateEvent(jpa);
        return this.notificationMapper.toEvent(jpaResult);
    }
}

