/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.filter;

import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.service.filter.INotificationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinimumPriorityNotificationFilter
implements INotificationFilter {
    private final int minPriority;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public MinimumPriorityNotificationFilter(int minPriority) {
        if (minPriority <= 0) {
            String msg = "Argument 'minPriority' must be greater than zero";
            throw new IllegalArgumentException("Argument 'minPriority' must be greater than zero");
        }
        this.minPriority = minPriority;
    }

    @Override
    public boolean doFilter(NotificationCategory category, NotificationEntry entry) {
        return this.isAtLeastMinimumPriority(entry);
    }

    private boolean isAtLeastMinimumPriority(NotificationEntry entry) {
        boolean rslt = entry.getPriority() <= this.minPriority && entry.getPriority() != 0;
        this.logger.debug("Filtering entry '{}'... minPriority='{}', entry.priority='{}', decision='{}'", new Object[]{entry.getTitle(), this.minPriority, entry.getPriority(), rslt});
        return rslt;
    }
}

