/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="usernameFinder")
public final class UsernameFinder {
    @Value(value="${UsernameFinder.unauthenticatedUsername}")
    private String unauthenticatedUsername = "guest";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Deprecated
    public String findUsername(PortletRequest req) {
        return req.getRemoteUser() != null ? req.getRemoteUser() : this.unauthenticatedUsername;
    }

    public String findUsername(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.logger.trace("Processing the following Authentication object:  {}", (Object)authentication);
        String rslt = (String)authentication.getPrincipal();
        this.logger.debug("Found username '{}' based on the contents of the SecurityContextHolder", (Object)rslt);
        if (rslt == null) {
            throw new SecurityException("User not identified");
        }
        return rslt;
    }

    public boolean isAuthenticated(PortletRequest req) {
        return !this.findUsername(req).equalsIgnoreCase(this.unauthenticatedUsername);
    }
}

