/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import org.dozer.Mapper;
import org.dozer.spring.DozerBeanMapperFactoryBean;
import org.jasig.portlet.notice.service.jpa.AddresseePostProcessor;
import org.jasig.portlet.notice.service.jpa.JpaAddressee;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.jasig.portlet.notice.service.jpa.JpaEntryPostProcessor;
import org.jasig.portlet.notice.service.jpa.NotificationDTOMapperEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class MappingConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean(value={"addresseePostProcessor"})
    public AddresseePostProcessor getAddresseePostProcessor() {
        return new AddresseePostProcessor();
    }

    @Bean
    public DozerBeanMapperFactoryBean getDozerBeanMapperFactory() {
        Resource mappingFile = this.applicationContext.getResource("classpath:/mapping/jpa-mappings.xml");
        JpaEntryPostProcessor jpaEntryPostProcessor = new JpaEntryPostProcessor();
        jpaEntryPostProcessor.setAddresseePostProcessor(this.getAddresseePostProcessor());
        HashMap<Class, Object> postProcessorMap = new HashMap<Class, Object>();
        postProcessorMap.put(JpaEntry.class, jpaEntryPostProcessor);
        postProcessorMap.put(JpaAddressee.class, this.getAddresseePostProcessor());
        NotificationDTOMapperEventListener listener = new NotificationDTOMapperEventListener();
        listener.setPostProcessorMap(postProcessorMap);
        ArrayList<NotificationDTOMapperEventListener> eventListeners = new ArrayList<NotificationDTOMapperEventListener>();
        eventListeners.add(listener);
        DozerBeanMapperFactoryBean rslt = new DozerBeanMapperFactoryBean();
        rslt.setMappingFiles(new Resource[]{mappingFile});
        rslt.setEventListeners(eventListeners);
        return rslt;
    }

    @Bean(value={"dozerBeanMapper"})
    public Mapper getDozerBeanMapper() {
        try {
            return this.getDozerBeanMapperFactory().getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

