/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.filter;

import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.service.filter.INotificationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MaximumPriorityNotificationFilter
implements INotificationFilter {
    private final int maxPriority;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public MaximumPriorityNotificationFilter(int maxPriority) {
        if (maxPriority <= 0) {
            String msg = "Argument 'maxPriority' must be greater than zero";
            throw new IllegalArgumentException("Argument 'maxPriority' must be greater than zero");
        }
        this.maxPriority = maxPriority;
    }

    @Override
    public boolean doFilter(NotificationCategory category, NotificationEntry entry) {
        return this.isNotHigherThanMaximumPriority(entry);
    }

    private boolean isNotHigherThanMaximumPriority(NotificationEntry entry) {
        boolean rslt = entry.getPriority() >= this.maxPriority || entry.getPriority() == 0;
        this.logger.debug("Filtering entry '{}'... maxPriority='{}', entry.priority='{}', decision='{}'", new Object[]{entry.getTitle(), this.maxPriority, entry.getPriority(), rslt});
        return rslt;
    }
}

