/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dozer.Mapper;
import org.jasig.portlet.notice.rest.AddresseeDTO;
import org.jasig.portlet.notice.rest.EntryDTO;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.rest.RecipientDTO;
import org.jasig.portlet.notice.service.jpa.INotificationDTOMapper;
import org.jasig.portlet.notice.service.jpa.JpaAddressee;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.jasig.portlet.notice.service.jpa.JpaEvent;
import org.jasig.portlet.notice.service.jpa.JpaRecipient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationDTOMapper
implements INotificationDTOMapper {
    @Autowired
    private Mapper dozerBeanMapper;

    @Override
    public List<EntryDTO> toEntryList(List<JpaEntry> entries) {
        return Lists.transform(entries, (Function)new Function<JpaEntry, EntryDTO>(){

            public EntryDTO apply(JpaEntry jpaEntry) {
                return NotificationDTOMapper.this.toEntry(jpaEntry);
            }
        });
    }

    @Override
    public List<JpaEntry> toJpaEntryList(List<EntryDTO> entries) {
        return Lists.transform(entries, (Function)new Function<EntryDTO, JpaEntry>(){

            public JpaEntry apply(EntryDTO entry) {
                return NotificationDTOMapper.this.toJpaEntry(entry);
            }
        });
    }

    @Override
    public EntryDTO toEntry(JpaEntry entry) {
        return (EntryDTO)this.dozerBeanMapper.map((Object)entry, EntryDTO.class);
    }

    @Override
    public JpaEntry toJpaEntry(EntryDTO entry) {
        return (JpaEntry)this.dozerBeanMapper.map((Object)entry, JpaEntry.class);
    }

    @Override
    public Set<AddresseeDTO> toAddresseeSet(Set<JpaAddressee> addressees) {
        HashSet<AddresseeDTO> set = new HashSet<AddresseeDTO>();
        for (JpaAddressee addr : addressees) {
            AddresseeDTO dto = this.toAddressee(addr);
            set.add(dto);
        }
        return set;
    }

    @Override
    public AddresseeDTO toAddressee(JpaAddressee addressee) {
        return (AddresseeDTO)this.dozerBeanMapper.map((Object)addressee, AddresseeDTO.class);
    }

    @Override
    public JpaAddressee toJpaAddressee(AddresseeDTO addressee) {
        return (JpaAddressee)this.dozerBeanMapper.map((Object)addressee, JpaAddressee.class);
    }

    @Override
    public List<RecipientDTO> toRecipientList(List<JpaRecipient> recipients) {
        return Lists.transform(recipients, (Function)new Function<JpaRecipient, RecipientDTO>(){

            public RecipientDTO apply(JpaRecipient jpaRecipient) {
                return NotificationDTOMapper.this.toRecipient(jpaRecipient);
            }
        });
    }

    @Override
    public RecipientDTO toRecipient(JpaRecipient recipient) {
        return (RecipientDTO)this.dozerBeanMapper.map((Object)recipient, RecipientDTO.class);
    }

    @Override
    public List<EventDTO> toEventList(List<JpaEvent> events) {
        return Lists.transform(events, (Function)new Function<JpaEvent, EventDTO>(){

            public EventDTO apply(JpaEvent jpaEvent) {
                return NotificationDTOMapper.this.toEvent(jpaEvent);
            }
        });
    }

    @Override
    public List<JpaEvent> toJpaEventList(List<EventDTO> events) {
        return Lists.transform(events, (Function)new Function<EventDTO, JpaEvent>(){

            public JpaEvent apply(EventDTO eventDTO) {
                return NotificationDTOMapper.this.toJpaEvent(eventDTO);
            }
        });
    }

    @Override
    public EventDTO toEvent(JpaEvent event) {
        return (EventDTO)this.dozerBeanMapper.map((Object)event, EventDTO.class);
    }

    @Override
    public JpaEvent toJpaEvent(EventDTO event) {
        return (JpaEvent)this.dozerBeanMapper.map((Object)event, JpaEvent.class);
    }
}

