/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.read;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.action.read.ReadAction;
import org.jasig.portlet.notice.service.AbstractNotificationServiceDecorator;

public class ReadNotificationServiceDecorator
extends AbstractNotificationServiceDecorator {
    public static final String READ_ENABLED_PREFERENCE = "ReadNotificationServiceDecorator.enabled";
    public static final String DEFAULT_READ_BEHAVIOR = "false";
    public static final String READ_ATTRIBUTE_NAME = "READ";
    private INotificationService enclosedNotificationService;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setEnclosedNotificationService(INotificationService enclosedNotificationService) {
        this.enclosedNotificationService = enclosedNotificationService;
    }

    public String getName() {
        return this.enclosedNotificationService.getName();
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.enclosedNotificationService.invoke(req, res, refresh);
    }

    public void collect(EventRequest req, EventResponse res) {
        this.enclosedNotificationService.collect(req, res);
    }

    public NotificationResponse fetch(PortletRequest req) {
        if (!this.readEnabled(req)) {
            return this.enclosedNotificationService.fetch(req);
        }
        NotificationResponse sourceResponse = this.enclosedNotificationService.fetch(req);
        NotificationResponse rslt = sourceResponse.cloneIfNotCloned();
        Set readNotificationIds = ReadAction.READ.getReadNotices(req);
        HashSet potentiallyMissingIds = new HashSet(readNotificationIds);
        NotificationAttribute readAttribute = new NotificationAttribute();
        readAttribute.setName(READ_ATTRIBUTE_NAME);
        readAttribute.setValues(new ArrayList<String>(Arrays.asList(new Boolean(true).toString())));
        for (NotificationCategory category : rslt.getCategories()) {
            for (NotificationEntry entry : category.getEntries()) {
                List currentList = entry.getAvailableActions();
                if (!StringUtils.isNotBlank((String)entry.getId())) continue;
                if (readNotificationIds.contains(entry.getId())) {
                    ArrayList<NotificationAttribute> attributes = new ArrayList<NotificationAttribute>(entry.getAttributes());
                    attributes.add(readAttribute);
                    entry.setAttributes(attributes);
                    potentiallyMissingIds.remove(entry.getId());
                }
                if (currentList.contains(ReadAction.READ)) continue;
                ArrayList<ReadAction> replacementList = new ArrayList<ReadAction>(currentList);
                boolean isMarkedRead = entry.getAttributes().contains(readAttribute);
                replacementList.add(!isMarkedRead ? ReadAction.createReadInstance() : ReadAction.createUnReadInstance());
                entry.setAvailableActions(replacementList);
            }
        }
        if (rslt.getErrors().isEmpty() && potentiallyMissingIds.size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing " + potentiallyMissingIds.size() + " unreferenced reads for user " + req.getRemoteUser()));
            }
            ReadAction.READ.removeReadNotices(req, potentiallyMissingIds);
        }
        return rslt;
    }

    private boolean readEnabled(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        return Boolean.valueOf(prefs.getValue(READ_ENABLED_PREFERENCE, DEFAULT_READ_BEHAVIOR));
    }

    public boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return this.enclosedNotificationService.isValid(req, previousResponse);
    }
}

