/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.security;

import javax.servlet.Filter;
import org.apereo.portal.soffit.security.SoffitApiAuthenticationManager;
import org.apereo.portal.soffit.security.SoffitApiPreAuthenticatedProcessingFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.support.ErrorPageFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${org.apereo.portal.soffit.jwt.signatureKey:CHANGEME}")
    private String signatureKey;

    public void configure(WebSecurity web) throws Exception {
        AntPathRequestMatcher pathMatcher = new AntPathRequestMatcher("/api/**");
        NegatedRequestMatcher inverseMatcher = new NegatedRequestMatcher((RequestMatcher)pathMatcher);
        web.ignoring().requestMatchers(new RequestMatcher[]{inverseMatcher});
    }

    protected void configure(HttpSecurity http) throws Exception {
        SoffitApiPreAuthenticatedProcessingFilter filter = new SoffitApiPreAuthenticatedProcessingFilter(this.signatureKey);
        filter.setAuthenticationManager(this.authenticationManager());
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.addFilter((Filter)filter).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/api/v1/**"})).access("hasRole('REST_READ') or hasRole('REST_WRITE')").antMatchers(HttpMethod.POST, new String[]{"/api/v1/**"})).hasRole("REST_WRITE").antMatchers(HttpMethod.DELETE, new String[]{"/api/v1/**"})).denyAll().antMatchers(HttpMethod.PUT, new String[]{"/api/v1/**"})).denyAll().antMatchers(HttpMethod.GET, new String[]{"/api/v2/**"})).authenticated().antMatchers(HttpMethod.POST, new String[]{"/api/v2/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{"/api/v2/**"})).denyAll().antMatchers(HttpMethod.PUT, new String[]{"/api/v2/**"})).denyAll().anyRequest()).permitAll().and()).sessionManagement().sessionFixation().none();
    }

    @Bean
    public AuthenticationManager authenticationManager() {
        return new SoffitApiAuthenticationManager();
    }

    @Bean
    public ErrorPageFilter errorPageFilter() {
        return new ErrorPageFilter();
    }

    @Bean
    public FilterRegistrationBean disableSpringBootErrorFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)this.errorPageFilter());
        filterRegistrationBean.setEnabled(false);
        return filterRegistrationBean;
    }

    @Bean(value={"soffitSignatureKey"})
    public String signatureKey() {
        return this.signatureKey;
    }
}

