/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.jpa.INotificationDao;
import org.jasig.portlet.notice.service.jpa.JpaAction;
import org.jasig.portlet.notice.service.jpa.JpaAttribute;
import org.jasig.portlet.notice.service.jpa.JpaEntry;
import org.jasig.portlet.notice.service.jpa.JpaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public class JpaNotificationService
extends AbstractNotificationService {
    static final String TABLENAME_PREFIX = "NOTICE_";
    public static final String ID_PREFIX = "jpa_";
    private static final String UNCATEGORIZED_MESSAGE_CODE = "uncategorized";
    private static final String UNCATEGORIZED_DEFAULT_MESSAGE = "(Uncategorized)";
    private static final String PREFS_ENABLED = "JpaNotificationService.enabled";
    @Autowired
    private INotificationDao notificationDao;
    @Autowired
    private MessageSource messages;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        PortletPreferences prefs = req.getPreferences();
        if (this.usernameFinder.isAuthenticated(req) && Boolean.parseBoolean(prefs.getValue(PREFS_ENABLED, "false"))) {
            String username = this.usernameFinder.findUsername(req);
            this.log.debug("Fetching notifications for user:  {}", (Object)username);
            Set entries = this.notificationDao.getEntriesByRecipient(username);
            this.log.debug("Found the following notifications for user '{}':  {}", (Object)username, (Object)entries.toString());
            rslt = this.prepareResponse(entries, username);
        }
        return rslt;
    }

    public NotificationResponse fetch(HttpServletRequest request) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        if (this.usernameFinder.isAuthenticated(request)) {
            String username = this.usernameFinder.findUsername(request);
            this.log.debug("Fetching notifications for user:  {}", (Object)username);
            Set entries = this.notificationDao.getEntriesByRecipient(username);
            this.log.debug("Found the following notifications for user '{}':  {}", (Object)username, (Object)entries.toString());
            rslt = this.prepareResponse(entries, username);
        }
        return rslt;
    }

    public void addEntryState(PortletRequest req, String entryId, NotificationState state) {
        if (this.usernameFinder.isAuthenticated(req)) {
            String username = this.usernameFinder.findUsername(req);
            String idStr = entryId.replaceAll(ID_PREFIX, "");
            JpaEntry jpaEntry = this.notificationDao.getEntry(Long.parseLong(idStr));
            if (jpaEntry != null) {
                JpaEvent event = new JpaEvent();
                event.setEntry(jpaEntry);
                event.setState(state);
                event.setTimestamp(new Timestamp(new Date().getTime()));
                event.setUsername(username);
                this.notificationDao.createOrUpdateEvent(event);
            } else {
                throw new IllegalArgumentException("JpaEntry not found");
            }
        }
    }

    private NotificationResponse prepareResponse(Set<JpaEntry> entries, String username) {
        HashMap<String, NotificationCategory> categories = new HashMap<String, NotificationCategory>();
        for (JpaEntry entry : entries) {
            NotificationEntry y;
            String categryTitle = !StringUtils.isBlank((String)entry.getCategory()) ? entry.getCategory() : this.messages.getMessage(UNCATEGORIZED_MESSAGE_CODE, null, UNCATEGORIZED_DEFAULT_MESSAGE, Locale.getDefault());
            NotificationCategory category = (NotificationCategory)categories.get(categryTitle);
            if (category == null) {
                category = new NotificationCategory();
                category.setTitle(categryTitle);
                categories.put(categryTitle, category);
            }
            if ((y = this.prepareEntry(entry, username)) == null) continue;
            category.addEntries(Collections.singletonList(y));
        }
        ArrayList cList = new ArrayList(categories.values());
        List eList = Collections.emptyList();
        return new NotificationResponse(cList, eList);
    }

    private NotificationEntry prepareEntry(JpaEntry entry, String username) {
        NotificationEntry rslt = new NotificationEntry();
        rslt.setId(ID_PREFIX + entry.getId());
        String title = entry.getTitle();
        if (StringUtils.isBlank((String)title)) {
            this.log.warn("User '" + username + "' had a notification with an empty title:  " + entry.toString());
            return null;
        }
        rslt.setTitle(title);
        if (!StringUtils.isBlank((String)entry.getBody())) {
            rslt.setBody(entry.getBody());
        }
        if (entry.getDueDate() != null) {
            rslt.setDueDate((Date)entry.getDueDate());
        }
        if (!StringUtils.isBlank((String)entry.getImage())) {
            rslt.setImage(entry.getImage());
        }
        if (!StringUtils.isBlank((String)entry.getLinkText())) {
            rslt.setLinkText(entry.getLinkText());
        }
        if (entry.getPriority() != 0) {
            rslt.setPriority(entry.getPriority());
        }
        if (!StringUtils.isBlank((String)entry.getSource())) {
            rslt.setSource(entry.getSource());
        }
        if (!StringUtils.isBlank((String)entry.getUrl())) {
            rslt.setUrl(entry.getUrl());
        }
        Map states = this.prepareStates(entry, username);
        rslt.setStates(states);
        if (!entry.getAttributes().isEmpty()) {
            List attributes = this.prepareAttributes(entry.getAttributes());
            rslt.setAttributes(attributes);
        }
        if (!entry.getActions().isEmpty()) {
            List actions = this.prepareActions(entry.getActions(), username);
            rslt.setAvailableActions(actions);
        }
        return rslt;
    }

    private Map<NotificationState, Date> prepareStates(JpaEntry entry, String username) {
        HashMap<NotificationState, Date> rslt = new HashMap<NotificationState, Date>();
        List events = this.notificationDao.getEvents(entry.getId(), username);
        Collections.reverse(events);
        for (JpaEvent e : events) {
            Set subsequentHistory = rslt.keySet();
            if (!e.getState().isActive((Date)e.getTimestamp(), subsequentHistory)) continue;
            rslt.put(e.getState(), e.getTimestamp());
        }
        return rslt;
    }

    private List<NotificationAttribute> prepareAttributes(Set<JpaAttribute> attributes) {
        ArrayList<NotificationAttribute> rslt = new ArrayList<NotificationAttribute>();
        for (JpaAttribute a : attributes) {
            NotificationAttribute n = new NotificationAttribute(a.getName(), a.getValues());
            rslt.add(n);
        }
        return rslt;
    }

    private List<NotificationAction> prepareActions(Set<JpaAction> actions, String username) {
        ArrayList<NotificationAction> rslt = new ArrayList<NotificationAction>();
        String className = null;
        try {
            for (JpaAction a : actions) {
                className = a.getClazz();
                Class<?> clazz = Class.forName(className);
                NotificationAction n = (NotificationAction)clazz.newInstance();
                n.setLabel(a.getLabel());
                rslt.add(n);
            }
        }
        catch (Exception e) {
            this.log.warn("User '" + username + "' had an action of an unknown className:  " + className);
        }
        return rslt;
    }
}

