/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.sort.SortOrder;
import org.jasig.portlet.notice.util.sort.SortStrategy;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Sorting {
    public static final String SORT_STRATEGY_PREFERENCE = "Sorting.sortStrategy";
    public static final String SORT_ORDER_PREFERENCE = "Sorting.sortOrder";
    public static final String SORT_ORDER_DEFAULT = SortOrder.ASCENDING.name();

    public static NotificationResponse sort(PortletRequest req, NotificationResponse data) {
        Comparator comparator = Sorting.chooseConfiguredComparator((PortletRequest)req);
        if (comparator == null) {
            return data;
        }
        ArrayList<NotificationCategory> copies = new ArrayList<NotificationCategory>();
        for (NotificationCategory category : data.getCategories()) {
            ArrayList entries = new ArrayList(category.getEntries());
            Collections.sort(entries, comparator);
            copies.add(new NotificationCategory(category.getTitle(), entries));
        }
        return new NotificationResponse(copies, data.getErrors());
    }

    public static List<NotificationEntry> sort(PortletRequest req, List<NotificationEntry> entries) {
        Comparator comparator = Sorting.chooseConfiguredComparator((PortletRequest)req);
        if (comparator == null) {
            return entries;
        }
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>(entries);
        Collections.sort(rslt, comparator);
        return rslt;
    }

    private static Comparator<NotificationEntry> chooseConfiguredComparator(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String strategyName = prefs.getValue("Sorting.sortStrategy", null);
        if (strategyName == null) {
            return null;
        }
        SortStrategy strategy = SortStrategy.valueOf((String)strategyName);
        String orderName = prefs.getValue("Sorting.sortOrder", SORT_ORDER_DEFAULT);
        SortOrder order = SortOrder.valueOf((String)orderName);
        return order.equals((Object)SortOrder.ASCENDING) ? strategy.getComparator() : Collections.reverseOrder(strategy.getComparator());
    }
}

