/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.filter.AbstractNotificationServiceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PriorityNotificationServiceFilter
extends AbstractNotificationServiceFilter {
    private static final String MIN_PRIORITY_PARAMETER_NAME = "minPriority";
    private static final String MAX_PRIORITY_PARAMETER_NAME = "maxPriority";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected PriorityNotificationServiceFilter() {
        super(-10);
    }

    @Override
    public NotificationResponse doFilter(HttpServletRequest request, INotificationServiceFilterChain chain) {
        NotificationResponse unfiltered = chain.doFilter();
        String minPriorityParameter = request.getParameter(MIN_PRIORITY_PARAMETER_NAME);
        String maxPriorityParameter = request.getParameter(MAX_PRIORITY_PARAMETER_NAME);
        if (StringUtils.isNotBlank((CharSequence)minPriorityParameter) || StringUtils.isNotBlank((CharSequence)maxPriorityParameter)) {
            Integer maxPriority;
            Integer minPriority = StringUtils.isNotBlank((CharSequence)minPriorityParameter) ? Integer.valueOf(minPriorityParameter) : null;
            Integer n = maxPriority = StringUtils.isNotBlank((CharSequence)maxPriorityParameter) ? Integer.valueOf(maxPriorityParameter) : null;
            if (minPriority != null && maxPriority != null && maxPriority > minPriority) {
                this.logger.warn("Invalid parameters;  the value of '{}' ({}) was higher than the value of '{}' ({})", new Object[]{MAX_PRIORITY_PARAMETER_NAME, maxPriority, MIN_PRIORITY_PARAMETER_NAME, minPriority});
                return NotificationResponse.EMPTY_RESPONSE;
            }
            return unfiltered.filter(entry -> {
                int priority = entry.getPriority();
                if (minPriority != null && priority > minPriority) {
                    return false;
                }
                return priority == 0 || maxPriority == null || priority >= maxPriority;
            });
        }
        return unfiltered;
    }
}

